package com.digiwin.athena.atdm.aam;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.AttachmentConstants;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.aam.dto.AttachmentEntity;
import com.digiwin.athena.atdm.aam.dto.DmcAccount;
import com.digiwin.athena.base.sdk.aam.application.meta.request.QueryAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.meta.response.AttachmentRespDTO;
import com.digiwin.athena.base.sdk.aam.application.service.QueryAttachmentService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Slf4j
public class CommonAttachmentServiceImpl implements CommonAttachmentService {
    private static final String QUERY_URL = "/api/aam/v1/attachment";

    @Autowired
    private RemoteProperties remoteProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private QueryAttachmentService queryAttachmentService;

    /**
     * 根据活动id、租户id和行数据标识列表查询
     *
     * @param tenantId       租户id
     * @param taskId         tmActivityId
     * @param categories     附件目录列表
     * @param rowDataKeyList 行数据标识列表
     * @return 附件信息
     */
    @Override
    public List<AttachmentEntity> queryRowDataAttachmentList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList) {
        QueryAttachmentReqDTO reqDTO = new QueryAttachmentReqDTO();
        reqDTO.setTenantId(tenantId);
        reqDTO.setTaskId(taskId);
        reqDTO.setProjectId(projectId);
        reqDTO.setCategoryList(categories);
        reqDTO.setRowDataKeyList(rowDataKeyList);

        List<AttachmentRespDTO> attachmentRespDTOS = queryAttachmentService.queryByTaskIdAndRowDataKeyList(reqDTO);
        if (CollectionUtils.isNotEmpty(attachmentRespDTOS)) {
            return attachmentRespDTOS.stream().map(AttachmentConverter.INSTANCE::toAttachmentEntity).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void uploadOrDeleteAttachment(List uploadedAttachmentList, List deletedAttachmentList, Boolean needDeleteDmcFile) {
        String url = remoteProperties.getAamUri() + "/api/aam/v1/uploadOrDeleteAttachment";

        Map<String, Object> body = new HashMap<>();
        body.put("uploadedFileList", uploadedAttachmentList);
        body.put("deletedFileList", deletedAttachmentList);
        body.put("needDeleteDmcFile", needDeleteDmcFile);

        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity httpEntity = new HttpEntity(body, headerMap);
        try {
            ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("[uploadOrDeleteAttachment] body: {}, error: ", JsonUtils.objectToString(body), ex);
            throw ex;
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void deleteAttachment(List deleteAttachmentList, Map<String, DmcAccount> schemaDmcAccountMap) {
        String url = remoteProperties.getAamUri() + "/api/aam/v1/deleteAttachmentBatch";

        Map<String, Object> body = new HashMap<>();
        body.put("deleteFileList", deleteAttachmentList);
        if (MapUtils.isNotEmpty(schemaDmcAccountMap)) {
            body.put(AttachmentConstants.SCHEMA_DMC_ACCOUNT_MAP, schemaDmcAccountMap);
        }
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity httpEntity = new HttpEntity(body, headerMap);
        try {
            ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("[uploadOrDeleteAttachment] body: {}, error: ", JsonUtils.objectToString(body), ex);
            throw ex;
        }
    }
}
