package com.digiwin.athena.atdm.action;


import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;

import java.util.Map;

/**
 * 提交的action 执行程序
 */
public interface ActionExecutor {

    /**
     * 处理的类型是什么
     *
     * @return
     */
    String supportKey();

    /**
     * 是否支持数据合并提交
     *
     * @return false：不支持；true：支持，默认false
     */
    default boolean supportDataMerge() {
        return false;
    }

    /**
     * actionId是否有元数据定义，像submit-data、dispatch等就没有元数据定义，esp包含的actionId就有元数据定义
     *
     * @return false：不是；true：是，默认false
     */
    default boolean hasActionMetadata() {
        return true;
    }

    /**
     * 执行逻辑
     *
     * @param action
     * @param data
     */
    ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data);

    default ExecuteResult execute(ActionExecuteReq actionExecuteReq){
        return execute(actionExecuteReq.getSubmitExecuteContext(),actionExecuteReq.getParentExecuteResult(),actionExecuteReq.getAction(),actionExecuteReq.getData());
    }

    /**
     * 是否支持重试
     *
     * @return
     */
    default boolean supportRetry() {
        return false;
    }
}

