package com.digiwin.athena.atdm.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jugg.agile.framework.core.util.concurrent.migration.JaTtlExecutors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Configuration
@EnableAsync
public class ExecutorConfig {
    @Value("${async.executor.thread.core_pool_size}")
    private int corePoolSize;
    @Value("${async.executor.thread.max_pool_size}")
    private int maxPoolSize;
    @Value("${async.executor.thread.queue_capacity}")
    private int queueCapacity;
    @Value("${async.executor.thread.name.prefix}")
    private String namePrefix;

    @Bean(name = "asyncServiceExecutor")
    public ExecutorService asyncServiceExecutor() {
        ThreadFactory normalThreadFactory = new ThreadFactoryBuilder().setNameFormat(namePrefix + "_%d").build();
        ThreadPoolExecutor executor = new ThreadPoolMonitor(corePoolSize
                , maxPoolSize
                , 60
                , TimeUnit.SECONDS
                , new ArrayBlockingQueue<>(queueCapacity)
                , queueCapacity
                , normalThreadFactory
                , namePrefix
                , new ThreadPoolExecutor.AbortPolicy());
        return JaTtlExecutors.getTtlExecutorService(executor);
    }
}
