package com.digiwin.athena.atdm.ptm.dto;

import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * PtmWithdrawReqDTO Description
 *
 * @author majianfu
 * @date 2022/10/11
 * @since
 */
@Data
public class PtmWithdrawReqDTO {
    /**
     * backlogId
     */
    private Long backlogId;

    /**
     * “撤回”操作执行人userId
     */
    private String performerId;

    /**
     * “撤回”操作执行人类型
     */
    private Integer performerType;

    /**
     * “撤回”操作备注
     */
    private String comment;

    /**
     * BK列表
     */
    private List<String> uniKeys;

    /**
     * 任务参数（id、业务数据）
     */
    private List<ParamReqDTO> parameter;

    /**
     * 流程变量中的key值
     */
    private String dataVariableKey;

    @Data
    public static class ParamReqDTO {
        /**
         * 撤回数据所对应的工作事项id
         */
        private Long workItemId;

        /**
         * 撤回的业务数据
         */
        private List<Map<String, Object>> data;

        /**
         * 需要同步移除数据的任务id列表
         */
        private Set<Long> nextWorkItemIdList;
    }
}
