package com.digiwin.athena.atdm.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class UriUtils {
    private UriUtils() {
    }

    /**
     * 解析http host
     *
     * @param httpUri 格式：https://datacomparison.apps.digiwincloud.com.cn  或者  https://datacomparison
     */
    public static String parseHttpHost(String httpUri) {
        if (StringUtils.isNotBlank(httpUri)) {
            String host = UriComponentsBuilder.fromHttpUrl(httpUri).build().getHost();
            if (StringUtils.isNotBlank(host)) {
                // 返回值格式：https://datacomparison.apps.digiwincloud.com.cn  或者  https://datacomparison
                return StringUtils.substring(httpUri, 0, httpUri.indexOf(host)) + host;
            }
        }
        return null;
    }
}
