/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.iam;

import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.iam.CommonUserService;
import com.digiwin.athena.atdm.iam.dto.UserDTO;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonUserServiceImpl
implements CommonUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonUserServiceImpl.class);
    @Autowired
    protected RemoteProperties envProperties;
    @Autowired
    protected RestTemplate restTemplate;

    @Override
    public UserDTO query(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/full";
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTO.class, new Object[0]);
            return (UserDTO)responseEntity.getBody();
        }
        catch (Exception ex) {
            log.error("{}, body: {}, error: ", new Object[]{ErrorCodeEnum.IAM_V2_USER.getErrCode(), JsonUtils.objectToString(param), ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.IAM_V2_USER.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public String getEmpIdByUserId(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "api/eoc/v2/emp/id";
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            Map body = (Map)responseEntity.getBody();
            if (body == null) {
                return null;
            }
            return body.get("data").toString();
        }
        catch (Exception ex) {
            log.error("{}, body: {}, error: ", new Object[]{ErrorCodeEnum.EOC_V2_EMP_ID.getErrCode(), JsonUtils.objectToString(param), ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.EOC_V2_EMP_ID.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public Integer queryUserType(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/query/user";
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            Map body = (Map)responseEntity.getBody();
            if (body == null) {
                return null;
            }
            return (Integer)body.get("userType");
        }
        catch (Exception ex) {
            log.error("{}, body: {}, error: ", new Object[]{ErrorCodeEnum.IAM_V2_QUERY_USER.getErrCode(), JsonUtils.objectToString(param), ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.IAM_V2_QUERY_USER.getErrCode(), (Exception)ex);
        }
    }
}

