/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.util;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ActivityUtils {
    public static Map<Long, List<Map<String, Object>>> classifySubmitDataByWorkItemId(List<Map<String, Object>> submitDataList) {
        HashMap<Long, List<Map<String, Object>>> workItemSubmitDataMap = new HashMap<Long, List<Map<String, Object>>>();
        for (Map<String, Object> submitData : submitDataList) {
            if (submitData.containsKey("activity__backLog__data")) {
                Map backlogData = (Map)submitData.get("activity__backLog__data");
                if (null != backlogData && null != backlogData.get("ptmBacklogId") && null != backlogData.get("ptmWorkItemId")) {
                    List workItemList = workItemSubmitDataMap.computeIfAbsent((Long)backlogData.get("ptmWorkItemId"), workItemId -> new ArrayList());
                    workItemList.add(submitData);
                    continue;
                }
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0033.getErrCode(), (String)((MessageUtils)JaSpringBeanUtil.getBean(MessageUtils.class)).getMessage("exception.task.withdraw.data.lack.necessary.config"));
            }
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0033.getErrCode(), (String)((MessageUtils)JaSpringBeanUtil.getBean(MessageUtils.class)).getMessage("exception.task.withdraw.data.lack.necessary.config"));
        }
        return workItemSubmitDataMap;
    }

    public static Map<Long, Map<String, Object>> groupByWorkItemId(Map<String, Object> parameter) {
        HashMap workItemToDataMap = Maps.newHashMapWithExpectedSize((int)parameter.size());
        for (Map.Entry<String, Object> entry : parameter.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof List)) continue;
            Map<Long, List<Map<String, Object>>> result = ActivityUtils.classifySubmitDataByWorkItemId((List)value);
            result.forEach((k, v) -> {
                HashMap row = Maps.newHashMapWithExpectedSize((int)1);
                row.put(entry.getKey(), v);
                workItemToDataMap.put(k, row);
            });
            break;
        }
        return workItemToDataMap;
    }

    public static Collection<Long> getMinSplitWorkItemIds(ActionExecuteReq actionExecuteReq) {
        Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if (MapUtils.isNotEmpty(workItemIdToData)) {
            return workItemIdToData.keySet();
        }
        Long backlogId = submitExecuteContext.getBacklogId();
        return Lists.newArrayList((Object[])new Long[]{backlogId});
    }

    public static Map<Long, Map<String, Object>> getMinSplitWorkItemToData(ActionExecuteReq actionExecuteReq) {
        LinkedHashMap workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        if (workItemIdToData == null) {
            SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
            workItemIdToData = Maps.newLinkedHashMapWithExpectedSize((int)1);
            workItemIdToData.put(submitExecuteContext.getBacklogId(), actionExecuteReq.getData());
        }
        return workItemIdToData;
    }
}

