/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.workflow;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.workflow.CommonWorkflowService;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonWorkflowServiceImpl
implements CommonWorkflowService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonWorkflowServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RemoteProperties envProperties;

    @Override
    public Map<String, Object> execute(Action action) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        ActionServiceId serviceId = action.getServiceId();
        if (serviceId == null) {
            log.warn("ServiceId null, actionId: {}", (Object)action.getActionId());
            return Maps.newHashMap();
        }
        if (StringUtils.hasText((String)serviceId.getProxyToken())) {
            headerMap.add("digi-middleware-auth-user", serviceId.getProxyToken());
            headerMap.add("token", serviceId.getProxyToken());
        }
        String serviceUri = this.envProperties.getWorkflowUri() + serviceId.getServiceUri();
        LogDto logDto = new LogDto("\u6267\u884c\u6d41\u7a0b\u5f15\u64ceaction\u5f00\u59cb\uff0cserviceUri\uff1a" + serviceUri, serviceId.getTenant_id() + ";" + serviceUri + ",\u7c7b\u578b:" + serviceId.getName() + ",\u63d0\u4ea4\u53c2\u6570:" + JsonUtils.objectToString(action.getParas()));
        log.info(logDto.toString());
        try {
            HttpEntity httpEntity = new HttpEntity(action.getParas(), (MultiValueMap)headerMap);
            ResponseEntity responseEntity = this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, new Object[0]);
            LogDto endLogDto = new LogDto("\u6267\u884c\u6d41\u7a0b\u5f15\u64ceaction\u6210\u529f\uff0cserviceUri\uff1a" + serviceUri, serviceId.getTenant_id() + ";" + serviceUri);
            log.info(endLogDto.toString());
            Map responseWithException = (Map)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
            if (!MapUtils.getBooleanValue((Map)responseWithException, (Object)"success")) {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0125.getErrCode(), (String)MapUtils.getString((Map)responseWithException, (Object)"message"));
            }
            return responseWithException;
        }
        catch (Exception ex) {
            LogDto errorLogDto = new LogDto("\u6267\u884c\u6d41\u7a0b\u5f15\u64ceaction\u5931\u8d25\uff0cserviceUri\uff1a" + serviceUri, serviceId.getTenant_id() + ";" + serviceUri);
            log.info(errorLogDto.toString());
            log.error("\u8c03\u7528\u5de5\u4f5c\u6d41\u63a5\u53e3\u9519\u8bef", (Throwable)ex);
            throw ex;
        }
    }
}

