package com.digiwin.athena.atdm.datasource.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;


/**
 * 多个数据源组成的集合
 */
public class QueryResultSet {

    private List<QueryResult> queryResults;

    private QueryResult mainQueryResult;

    public List<QueryResult> getQueryResults() {
        return queryResults;
    }

    public void setMainQueryResult(QueryResult mainQueryResult){
        this.mainQueryResult = mainQueryResult;
    }

    public QueryResult getMainQueryResult() {
        if (mainQueryResult==null && !this.queryResults.isEmpty()) {
            mainQueryResult = this.queryResults.get(0);
        }
        return mainQueryResult;
    }

    private QueryResultSet(){
    }
    public static QueryResultSet empty() {
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.queryResults = new ArrayList<>();
        queryResultSet.mainQueryResult = QueryResult.empty();
        return queryResultSet;
    }

    public static QueryResultSet withData(String mainDatasource, List<QueryResult> queryResultList){
        if (queryResultList ==null){
            throw  new IllegalArgumentException("queryResultList");
        }

        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.queryResults = queryResultList;
        if (StringUtils.hasText(mainDatasource)){
            for (QueryResult queryResult : queryResultList) {
                if (mainDatasource.equals(queryResult.getDataSourceName())){
                    queryResultSet.mainQueryResult = queryResult;
                    break;
                }
            }
        }else {
            if (!queryResultList.isEmpty()) {
                queryResultSet.mainQueryResult = queryResultList.get(0);
            }else {
                queryResultSet.mainQueryResult = QueryResult.empty();
            }
        }
        return queryResultSet;
    }

    public QueryResultSet appendData(QueryResult queryResult){
        if (queryResult ==null){
            throw  new IllegalArgumentException("queryResult");
        }
        this.queryResults.add(queryResult);
        return this;
    }


    public  boolean contains(String name){
        return this.queryResults.stream().anyMatch((queryResult -> name.equals( queryResult.getDataSourceName())));
    }
    @JsonIgnore
    public QueryResult get(String name){
        Optional<QueryResult> optionalQueryResult = this.queryResults.stream()
                .filter((queryResult -> name.equals( queryResult.getDataSourceName()) )).findFirst();
        if (optionalQueryResult.isPresent()){
            return optionalQueryResult.get();
        } else {
            return null;
        }
    }
    @JsonIgnore
    public Map<String, Object> getPageData(){
        Map pageData = new HashMap<>();
        for (QueryResult queryResult : queryResults) {
            if(queryResult.isSingle() && CollectionUtils.isNotEmpty(queryResult.getData())){
                pageData.put(queryResult.getDataSourceName(),queryResult.getData().get(0));
            }else{
                pageData.put(queryResult.getDataSourceName(),queryResult.getData());
            }
        }
        return pageData;
    }

    /**
     * 获取数据索引字段
     * @return
     */
    @JsonIgnore
    public Map<String, Map<String, Integer>> getPageDataIndex(){
        Map pageData = new HashMap<>();
        for (QueryResult queryResult : queryResults) {
            pageData.put(queryResult.getDataSourceName(),queryResult.getDataKeyIndex());
        }
        return pageData;
    }

    /**
     * 获取数据索引字段集合
     *
     * @return
     */
    public Map<String, List<String>> getPageDataKeys() {
        Map<String, List<String>> pageDataKeys = new HashMap<>();
        for (QueryResult queryResult : queryResults) {
            pageDataKeys.put(queryResult.getDataSourceName(), queryResult.getDataKeys());
        }
        return pageDataKeys;
    }

}
