package com.digiwin.athena.atdm.datasource.dto;

import lombok.Getter;
import lombok.Setter;

/**
 * 数据状态映射关系配置
 * {@link DataStatus}是作用在 {@link com.digiwin.athena.uibot.activity.domain.QueryDTO} 类下
 * 在解析{@link GridComponent} {@link ListComponent} 这两个组件的时候需要执行{@link #createDefault()}来赋默认值
 * 但是这两个组件存在QueryDTO为null的场景，这就造成了下对上的依赖。
 * <p>
 * 2025-07-05 更新
 * 数据状态映射关系配置 不仅仅在表格组件中，也可能在整个应用级别下做数据状态映射关系
 */

@Getter
@Setter
public class DataStatus {


    /**
     * default : uibot_data_status
     */
    private String key;

    /**
     * default: not-changed
     */
    private String notChanged;

    /**
     * default: changed
     */
    private String changed;


    /**
     * default: delete
     */
    private String delete;

    /**
     * default:new-data
     */
    private String newData;


    /**
     * 创建默认数据状态
     */
    public static DataStatus createDefault() {
        DataStatus dataStatus = new DataStatus();
        dataStatus.setNewData("new-data");
        dataStatus.setChanged("changed");
        dataStatus.setDelete("delete");
        dataStatus.setKey("uibot_data_status");
        dataStatus.setNotChanged("not-changed");
        return dataStatus;
    }
}
