package com.digiwin.athena.atdm.util;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import org.apache.commons.collections4.MapUtils;
//import org.apache.commons.collections4.MapUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActivityUtils {

    public static Map<Long, List<Map<String, Object>>> classifySubmitDataByWorkItemId(List<Map<String, Object>> submitDataList) {
        // [workItemId, List<提交数据：没行数据中，可能workItemId是一样的>]
        Map<Long, List<Map<String, Object>>> workItemSubmitDataMap = new HashMap<>();
        for (Map<String, Object> submitData : submitDataList) {
            if (submitData.containsKey("activity__backLog__data")) {
                Map<String, Object> backlogData = (Map<String, Object>) submitData.get("activity__backLog__data");
                if (null != backlogData
                        && null != backlogData.get("ptmBacklogId")
                        && null != backlogData.get("ptmWorkItemId")) { // work_item_id
                    List<Map<String, Object>> workItemList = workItemSubmitDataMap.computeIfAbsent((Long) backlogData.get("ptmWorkItemId"), workItemId -> new ArrayList<>());
                    workItemList.add(submitData);
                } else {
                    // 抛出异常
                    throw BusinessException.create(ErrorCodeEnum.NUM_500_0033.getErrCode(), JaSpringBeanUtil.getBean(MessageUtils.class).getMessage("exception.task.withdraw.data.lack.necessary.config"));
                }
            } else {
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0033.getErrCode(),JaSpringBeanUtil.getBean(MessageUtils.class).getMessage("exception.task.withdraw.data.lack.necessary.config"));
            }
        }
        return workItemSubmitDataMap;
    }

    public static Map<Long,Map<String, Object>> groupByWorkItemId(Map<String, Object> parameter){
        Map<Long,Map<String,Object>> workItemToDataMap = Maps.newHashMapWithExpectedSize(parameter.size());
        for (Map.Entry<String, Object> entry:parameter.entrySet()){
            Object value = entry.getValue();
            if(value instanceof List){
                Map<Long, List<Map<String, Object>>> result = classifySubmitDataByWorkItemId((List<Map<String, Object>>) value);
                result.forEach((k,v)->{
                    Map<String,Object> row = Maps.newHashMapWithExpectedSize(1);
                    row.put(entry.getKey(),v);
                    workItemToDataMap.put(k,row);
                });
                break;
            }
        }
        return workItemToDataMap;
    }

    public static Collection<Long> getMinSplitWorkItemIds(ActionExecuteReq actionExecuteReq){
        Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if(MapUtils.isNotEmpty(workItemIdToData)){
            return workItemIdToData.keySet();
        }
        Long backlogId = submitExecuteContext.getBacklogId();
        return Lists.newArrayList(backlogId);

    }

    public static Map<Long, Map<String, Object>> getMinSplitWorkItemToData(ActionExecuteReq actionExecuteReq){
        Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        if(workItemIdToData == null){
            SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
            workItemIdToData = Maps.newLinkedHashMapWithExpectedSize(1);
            workItemIdToData.put(submitExecuteContext.getBacklogId(),actionExecuteReq.getData());
        }
        return workItemIdToData;

    }
}
