package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * ATMC逾期任务卡数据源
 */
@Data
public class AtmcOverdueTaskDataSource extends DataSourceBase {

    private final static String PARA_NAME = "queryMap";

    public AtmcOverdueTaskDataSource() {
        super();
        this.setType(UiBotConstants.ACTION_CATEGORY_ATMC);
    }

    /**
     * 查询数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @return
     */
    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> orderInfo,List<Map> searchInfo) {
        QueryAction action = this.getAction();

        String backlogId = null;
        if (action != null && action.getParas() != null && action.getParas().containsKey("backlogId")) {
            backlogId = action.getParas().get("backlogId").toString();
        }
        else if(parameter!=null && parameter.containsKey("backlogId")){
            backlogId = parameter.get("backlogId").toString();
        }
//        if (StringUtils.isEmpty(backlogId)) {
//            return QueryResult.empty(this.getName());
//        }
        if(null == action)
        {
            return QueryResult.empty(this.getName());
        }

        String actionId = action.getActionId();
        if (StringUtils.isEmpty(actionId)) {
            return QueryResult.empty(this.getName());
        }

        if (Objects.equals(actionId, "atmc.get.overdue.task.datasource")) {
            return getOverdueTaskDataSource(backlogId);
        } else if (Objects.equals(actionId, "atmc.get.overdue.task.list.datasource")) {
            return getOverdueTaskListDataSource(backlogId);
        } else if (Objects.equals(actionId, "atmc.show.overdue.task.original")) {
            return getOverdueTaskListDataSource(backlogId);
        } else {
            return executeAtmcDataSourceDataQuery(executeContext, parameter);
        }
    }

    private QueryResult executeAtmcDataSourceDataQuery(ExecuteContext executeContext, Map<String, Object> parameter) {
        List<Object> resultList = SpringUtil.getBean(CommonAtmcService.class).executeDataSourceDataQuery(executeContext, this.getAction(), parameter);

        Map<String, List<Object>> data = new HashMap<>();
        data.put("atmc_data", resultList);
        return QueryResult.withData(this.getName(), data);
    }

    private QueryResult getOverdueTaskDataSource(String backlogId) {
        Map map = new HashMap();
        map.put("backlogId", backlogId);

        List<Map> value = SpringUtil.getBean(CommonAtmcService.class).getOverdueTaskDataSource(map);

        List<Object> list = new ArrayList<>();
        if (value != null) {
            value.forEach(m -> {
                list.add(m);
            });
        }
        Map<String, List<Object>> espData = new HashMap<>();
        espData.put("atmc_data", list);
        return QueryResult.withData(this.getName(), espData);
    }

    private QueryResult getOverdueTaskListDataSource(String backlogId) {
        Map map = new HashMap();
        map.put("backlogId", backlogId);

        List<Map> value = SpringUtil.getBean(CommonAtmcService.class).getOverdueTaskListDataSource(map);

        List<Object> list = new ArrayList<>();
        if (value != null) {
            value.forEach(m -> {
                list.add(m);
            });
        }
        Map<String, List<Object>> espData = new HashMap<>();
        espData.put("atmc_data", list);
        return QueryResult.withData(this.getName(), espData);
    }

    /**
     * 附加数据的元数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @param queryResult    查询结果
     * @return
     */
    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        //查询元数据
        ApiMetadataCollection apiMetadataCollection = ApiMetadataCollection.empty();
        apiMetadataCollection.getMasterApiMetadata().setActionId(this.getActionId());
        apiMetadataCollection.getMasterApiMetadata().setServiceName(this.getAction().getServiceId().getName());
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        AtmcOverdueTaskDataSource ds = new AtmcOverdueTaskDataSource();
        ds.setName(this.getName());
        ds.setAction(this.getAction());
        ds.setType(this.getType());
        ds.setDataKeys(this.getDataKeys());
        ds.setActionId(this.getActionId());
        return ds;
    }
}
