package com.digiwin.athena.atdm.datasource.dto;

import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import lombok.Data;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;


@Data
public class DataQueryDTO {
    //兼容以前的代码，继续保留
    private DataSourceSetDTO dataSourceSetDTO;
    //兼容以前的代码,继续保留
    private DataSourceDTO dataSourceDTO;

    private DataSourceDTO dataSource;

    private DataSourceSetDTO dataSourceSet;

    /**
     * 分页查询参数
     */
    private PageInfo pageInfo;

    /**
     *  "sort_info" : [{
     *           "sort_field" : "requisitions_no",
     *           "sort_type" : "asc",
     *           "sort_seq" : "1"
     *       },{
     *           "sort_field" : "requisitions_seq",
     *           "sort_type" : "desc",
     *           "sort_seq" : "2"
     *       }]
     */
    private List<Map> sortInfo;
    /**
     * 通用过滤
     * "search_info": [
     *         {
     *           "search_field": "name",
     *           "search_operator": "equal",
     *           "search_value": "印表機"
     *         },
     *         {
     *           "search_field": "status",
     *           "search_operator": "equal",
     *           "search_value": "生效"
     *         }
     *       ]
     */
    private List<Map> searchInfo;

    /**
     *
     */
    private String rowSizeType;
    /**
     * 业务参数数据
     */
    private Map<String,Object> parameter;

    /**
     * 执行上下文
     */
    private ExecuteContext executeContext;


    /**
     * 分组 支持 treeTable 的样式
     */
    private JSONObject settings;

    /**
     * 分页查询SCS数据时，表头字段，用于筛选项查询
     */
    private List<String> conditionFeildId;

    /**
     * 数据的状态
     *    waiting 待处理
     *    tracing 追踪中
     *    completed 已完成
     *    processing 处理中
     */
    private String dataStateCode;

    /**
     * 单身/子单身 分页信息
     */
    private Map<String, Object> returnRequestData;

    /**
     * 用于暂存前端传递过来的参数
     */
    private transient PageInfo tempPageInfo;

}
