/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.process.ActivityUtils;
import com.digiwin.athena.atdm.datasource.datasource.process.ApprovalUtil;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import com.digiwin.athena.atdm.datasource.datasource.process.DeriveUtil;
import com.digiwin.athena.atdm.datasource.datasource.process.SolveUtil;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.TaskWithBacklogData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="atmcDataService")
public class AtmcDataSourceService
implements DataSourceProcessService {
    private static final Integer CREATE_TYPE_WITHDRAW = 9;
    private static final List<Integer> DATA_FLOW_STATUS_LIST = Arrays.asList(CREATE_TYPE_WITHDRAW);
    public static final String GROUP_ORDER_SETTING_KEY = "project-settings";
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (!"task-detail".equals(executeContext.getPageCode()) && !"project-detail".equals(executeContext.getPageCode())) {
            return;
        }
        this.addAtmcFiled(dataSourceBase, executeContext, dataSourceProcessor, queryResult.getApiMetadataCollection());
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        TaskWithBacklogData taskWithBacklogData;
        Map processParas;
        if (!"task-detail".equals(executeContext.getPageCode()) && !"project-detail".equals(executeContext.getPageCode())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)queryResult.getData())) {
            return;
        }
        if (Objects.isNull(dataSourceProcessor.getTaskWithBacklogData())) {
            return;
        }
        String detailField = null;
        if (dataSourceProcessor.getParas() != null && (processParas = (Map)dataSourceProcessor.getParas()).containsKey("detailField")) {
            detailField = (String)processParas.get("detailField");
        }
        if (!CollectionUtils.isEmpty((Collection)(taskWithBacklogData = dataSourceProcessor.getTaskWithBacklogData()).getBacklog())) {
            BacklogData firstBacklogData = (BacklogData)taskWithBacklogData.getBacklog().get(0);
            boolean isPerformer = AtmcDataSourceService.isPerformer(executeContext.getSettings());
            if (!isPerformer) {
                firstBacklogData.setPerformerState(null);
            }
            boolean hasPrePerformerId = firstBacklogData.getPrePerformerId() != null || firstBacklogData.getPreAgentPerformerId() != null;
            HashMap<String, Object> activityDataStatus = new HashMap<String, Object>();
            activityDataStatus.put("withdraw", AtmcDataSourceService.isTaskWithdraw(firstBacklogData));
            for (Map data : queryResult.getData()) {
                firstBacklogData.setProcessSerialNumber(taskWithBacklogData.getProcessSerialNumber());
                firstBacklogData.setTaskUid(taskWithBacklogData.getTaskUid());
                data.put("activity__backLog__data", firstBacklogData);
                data.put("activity__remainTime", firstBacklogData.getRemainTime());
                data.put("activity__performerName", firstBacklogData.getPerformerName());
                if (hasPrePerformerId) {
                    if (firstBacklogData.getPrePerformerType() != null && firstBacklogData.getPrePerformerType() > 0) {
                        data.put("activity__prePerformer_Id", firstBacklogData.getPreAgentPerformerId());
                        data.put("activity__prePerformer_Name", firstBacklogData.getPreAgentPerformerName());
                    } else {
                        data.put("activity__prePerformer_Id", firstBacklogData.getPrePerformerId());
                        data.put("activity__prePerformer_Name", firstBacklogData.getPrePerformerName());
                    }
                }
                if (taskWithBacklogData.getBusinessUnit() != null) {
                    data.put("businessUnit", taskWithBacklogData.getBusinessUnit());
                } else {
                    data.put("businessUnit", executeContext.getBusinessUnit());
                }
                data.put("activity__planEndTime", firstBacklogData.getPlanEndTime());
                data.put("activity__readCount", firstBacklogData.getReadCount());
                ActivityUtils.addActivityData(data, firstBacklogData);
                if ("SOLVE".equals(executeContext.getCategory())) {
                    SolveUtil.addTraceData(executeContext, detailField, taskWithBacklogData, firstBacklogData, data);
                } else if ("APPROVAL".equals(executeContext.getCategory()) && executeContext.getIdentity().equals("charge")) {
                    ApprovalUtil.addTaskData(executeContext, taskWithBacklogData, firstBacklogData, data);
                } else if ("DERIVE".equals(executeContext.getPattern()) && taskWithBacklogData.getBpmData() != null && taskWithBacklogData.getBpmData().containsKey("__DERIVE_TASK_RELATION_UNIKEYS") && taskWithBacklogData.getBpmData().containsKey("__DERIVE_TASK_RELATION")) {
                    DeriveUtil.addSubTaskData(taskWithBacklogData, data);
                }
                activityDataStatus.put("returnInfo", ApprovalUtil.addReturnComments(firstBacklogData, data));
                data.put("activity__data__status", activityDataStatus);
                if ("APPROVAL".equals(executeContext.getCategory()) || !executeContext.getIdentity().equals("performer") || null == taskWithBacklogData.getRelationApproval()) continue;
                ApprovalUtil.addTaskData(taskWithBacklogData, firstBacklogData, data);
            }
            if ("SOLVE".equals(executeContext.getCategory()) && "waitting".equals(executeContext.getDataStateCode()) && taskWithBacklogData.getBpmData() != null && taskWithBacklogData.getBpmData().containsKey("checkResult")) {
                this.addCheckResult(dataSourceBase, queryResult, taskWithBacklogData);
            }
        }
    }

    private void addCheckResult(DataSourceBase dataSourceBase, QueryResult queryResult, TaskWithBacklogData taskWithBacklogData) {
        List checkResult = (List)taskWithBacklogData.getBpmData().get("checkResult");
        if (!CollectionUtils.isEmpty(dataSourceBase.getDataKeys())) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map datum : checkResult) {
                String key;
                Map findItem;
                stringBuilder.setLength(0);
                for (String key2 : dataSourceBase.getDataKeys()) {
                    if (datum.containsKey(key2)) {
                        stringBuilder.append(StringUtils.isEmpty(datum.get(key2)) ? "NAN" : datum.get(key2).toString()).append(";");
                        continue;
                    }
                    stringBuilder.append("NAN;");
                }
                if (stringBuilder.length() <= 0 || (findItem = queryResult.findByKey(key = stringBuilder.toString())) == null) continue;
                findItem.put("check_result", datum.get("result"));
            }
        }
    }

    private void addAtmcFiled(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, ApiMetadataCollection apiMetadataCollection) {
        TaskWithBacklogData taskWithBacklogData;
        if (apiMetadataCollection == null || apiMetadataCollection.getMasterApiMetadata().getResponseFields().size() == 0) {
            return;
        }
        MetadataField performerNameMetadataField = new MetadataField();
        performerNameMetadataField.setUiBot("Y");
        performerNameMetadataField.setName("activity__performerName");
        performerNameMetadataField.setDataType("string");
        performerNameMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.performerName"));
        MetadataField planEndTimeMetadataField = new MetadataField();
        planEndTimeMetadataField.setUiBot("Y");
        planEndTimeMetadataField.setName("activity__planEndTime");
        planEndTimeMetadataField.setDataType("string");
        planEndTimeMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.planEndTime"));
        MetadataField readCountMetadataField = new MetadataField();
        readCountMetadataField.setUiBot("Y");
        readCountMetadataField.setName("activity__readCount");
        readCountMetadataField.setDataType("string");
        readCountMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.readCount"));
        MetadataField dataStatusMetadataField = new MetadataField();
        dataStatusMetadataField.setUiBot("Y");
        dataStatusMetadataField.setName("activity__backLog__data");
        dataStatusMetadataField.setDataType("object");
        dataStatusMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.dataStatus"));
        List metadataFields = ((MetadataField)apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields();
        metadataFields.add(performerNameMetadataField);
        metadataFields.add(planEndTimeMetadataField);
        metadataFields.add(readCountMetadataField);
        metadataFields.add(dataStatusMetadataField);
        ActivityUtils.addActivityMetadataField(metadataFields, this.messageUtils);
        if (!"SHELVED_DATA".equals(dataSourceBase.getType())) {
            metadataFields.add(this.createDataFlowStatusField());
        }
        if ((taskWithBacklogData = dataSourceProcessor.getTaskWithBacklogData()) != null) {
            HashMap task;
            if ("SOLVE".equals(executeContext.getCategory()) || "APPROVAL".equals(executeContext.getCategory()) && executeContext.getIdentity().equals("charge")) {
                BacklogData firstBacklogData;
                if (!(CollectionUtils.isEmpty((Collection)taskWithBacklogData.getBacklog()) || (firstBacklogData = (BacklogData)taskWithBacklogData.getBacklog().get(0)).getPrePerformerId() == null && firstBacklogData.getPreAgentPerformerId() == null)) {
                    MetadataField prePerformerNameMetadataField = new MetadataField();
                    prePerformerNameMetadataField.setUiBot("Y");
                    prePerformerNameMetadataField.setName("activity__prePerformer_Name");
                    prePerformerNameMetadataField.setDataType("string");
                    prePerformerNameMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.performerName"));
                    MetadataField prePerformerIdMetadataField = new MetadataField();
                    prePerformerIdMetadataField.setUiBot("Y");
                    prePerformerIdMetadataField.setName("activity__prePerformer_Id");
                    prePerformerIdMetadataField.setDataType("string");
                    prePerformerIdMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.performerName"));
                    metadataFields.add(prePerformerIdMetadataField);
                    metadataFields.add(prePerformerNameMetadataField);
                }
                MetadataField dataTranceStatusMetadataField = new MetadataField();
                dataTranceStatusMetadataField.setUiBot("Y");
                dataTranceStatusMetadataField.setName("activity__approval__state");
                dataTranceStatusMetadataField.setDataType("string");
                dataTranceStatusMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.approvalStatus"));
                metadataFields.add(dataTranceStatusMetadataField);
                if (taskWithBacklogData.getBpmData() != null && "waitting".equals(executeContext.getDataStateCode()) && taskWithBacklogData.getBpmData().containsKey("checkResult")) {
                    MetadataField checkResultMetadataField = new MetadataField();
                    checkResultMetadataField.setArray(Boolean.valueOf(true));
                    checkResultMetadataField.setUiBot("Y");
                    checkResultMetadataField.setName("check_result");
                    if ("task-detail".equals(executeContext.getPageCode()) || "project-detail".equals(executeContext.getPageCode())) {
                        checkResultMetadataField.setTagDefinitions(CustomizeTagUtils.createOrderTagDefinitions("999"));
                    }
                    checkResultMetadataField.setDescription(this.messageUtils.getMessage("uibot.acitivity.check.title"));
                    checkResultMetadataField.setDataType("object");
                    ArrayList<MetadataField> subFields = new ArrayList<MetadataField>();
                    MetadataField keyMetadataField = new MetadataField();
                    keyMetadataField.setUiBot("Y");
                    keyMetadataField.setArray(Boolean.valueOf(false));
                    keyMetadataField.setName("key");
                    keyMetadataField.setDataType("string");
                    subFields.add(keyMetadataField);
                    MetadataField nameMetadataField = new MetadataField();
                    nameMetadataField.setArray(Boolean.valueOf(false));
                    nameMetadataField.setUiBot("Y");
                    nameMetadataField.setName("name");
                    nameMetadataField.setDataType("string");
                    subFields.add(nameMetadataField);
                    MetadataField standardValueMetadataField = new MetadataField();
                    standardValueMetadataField.setArray(Boolean.valueOf(false));
                    standardValueMetadataField.setUiBot("Y");
                    standardValueMetadataField.setName("standardValue");
                    standardValueMetadataField.setDataType("string");
                    subFields.add(standardValueMetadataField);
                    MetadataField valueMetadataField = new MetadataField();
                    valueMetadataField.setArray(Boolean.valueOf(false));
                    valueMetadataField.setUiBot("Y");
                    valueMetadataField.setName("value");
                    valueMetadataField.setDataType("string");
                    subFields.add(valueMetadataField);
                    MetadataField dropValueMetadataField = new MetadataField();
                    dropValueMetadataField.setArray(Boolean.valueOf(false));
                    dropValueMetadataField.setUiBot("Y");
                    dropValueMetadataField.setName("dropValue");
                    dropValueMetadataField.setDataType("string");
                    subFields.add(dropValueMetadataField);
                    MetadataField yesOrNoMetadataField = new MetadataField();
                    yesOrNoMetadataField.setArray(Boolean.valueOf(false));
                    yesOrNoMetadataField.setUiBot("Y");
                    yesOrNoMetadataField.setName("yesOrNo");
                    yesOrNoMetadataField.setDataType("boolean");
                    subFields.add(yesOrNoMetadataField);
                    checkResultMetadataField.setSubFields(subFields);
                    metadataFields.add(checkResultMetadataField);
                }
            } else if ("DERIVE".equals(executeContext.getPattern()) && taskWithBacklogData.getBpmData() != null && taskWithBacklogData.getBpmData().containsKey("__DERIVE_TASK_RELATION") && taskWithBacklogData.getBpmData().containsKey("__DERIVE_TASK_RELATION_UNIKEYS") && (task = (HashMap)taskWithBacklogData.getBpmData().get("__DERIVE_TASK_RELATION")) != null && task.size() > 0) {
                for (Object key : task.keySet()) {
                    MetadataField subTaskMetadataField = new MetadataField();
                    subTaskMetadataField.setUiBot("Y");
                    subTaskMetadataField.setName("uibot__" + key + "__subTask");
                    subTaskMetadataField.setDataType("object");
                    subTaskMetadataField.setDescription(key.toString());
                    metadataFields.add(subTaskMetadataField);
                }
            }
        }
    }

    private MetadataField createDataFlowStatusField() {
        MetadataField dataFlowStatusField = new MetadataField();
        dataFlowStatusField.setUiBot("Y");
        dataFlowStatusField.setName("activity__data__status");
        dataFlowStatusField.setDataType("object");
        dataFlowStatusField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.dataFlowStatus"));
        return dataFlowStatusField;
    }

    public static int isTaskWithdraw(BacklogData backlogData) {
        if (!AtmcDataSourceService.isDataFlowStatusCreateType(backlogData)) {
            return 0;
        }
        Integer createType = (Integer)((Map)backlogData.getWorkitemList().get(0)).get("createType");
        return CREATE_TYPE_WITHDRAW.equals(createType) ? 1 : 0;
    }

    public static Map<String, Object> dealReturnComment(BacklogData backlogData, List<Map<String, Object>> data) {
        List workitemList = backlogData.getWorkitemList();
        for (Map workitem : workitemList) {
            List returnWorkitem = (List)workitem.get("returnWorkitem");
        }
        return null;
    }

    public static boolean isPerformer(JSONObject settings) {
        boolean isPerformer = false;
        if (null == settings || !settings.containsKey((Object)GROUP_ORDER_SETTING_KEY)) {
            return true;
        }
        JSONObject setObject = settings.getJSONObject(GROUP_ORDER_SETTING_KEY);
        JSONArray operations = JSONArray.fromObject((Object)setObject.get("options"));
        if (operations.size() > 0) {
            for (Object obj : operations) {
                JSONObject groupObj = JSONObject.fromObject(obj);
                if (!groupObj.containsKey((Object)"value") || !Objects.equals("activity__performerName", groupObj.getString("value"))) continue;
                isPerformer = true;
                break;
            }
        }
        return isPerformer;
    }

    public static boolean isDataFlowStatusCreateType(BacklogData backlogData) {
        if (null == backlogData || CollectionUtils.isEmpty((Collection)backlogData.getWorkitemList())) {
            return false;
        }
        Map workItem = (Map)backlogData.getWorkitemList().get(0);
        if (MapUtils.isEmpty((Map)workItem) || null == workItem.get("createType")) {
            return false;
        }
        Integer createType = (Integer)workItem.get("createType");
        return DATA_FLOW_STATUS_LIST.contains(createType);
    }
}

