/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.dataUniformity.DataUniformityMongodbService;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.DataUniformityDTO;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataUnfiormityProcessor {
    private static final Logger log = LoggerFactory.getLogger(DataUnfiormityProcessor.class);
    @Autowired
    private DataUniformityMongodbService mongodbService;
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private CommonSmartDataService commonSmartDataService;
    @Autowired
    private AsyncEventBus asyncEventBus;

    public Set<Map<String, Object>> comparisonData(List<Map<String, Object>> allDataList, DataSourceProcessor dataSourceProcessor) {
        ArrayList<Object> abnormalBkList = new ArrayList<Object>();
        List parasList = (List)dataSourceProcessor.getParas();
        for (Object parasObj : parasList) {
            abnormalBkList.add(JsonUtils.jsonToObject((String)JsonUtils.objectToString(parasObj), DataUniformityDTO.class));
        }
        if (CollectionUtils.isEmpty(allDataList) || CollectionUtils.isEmpty(abnormalBkList)) {
            return new HashSet<Map<String, Object>>();
        }
        HashSet<Map<String, Object>> abnormalDataSet = new HashSet<Map<String, Object>>();
        for (DataUniformityDTO dataUniformityDTO : abnormalBkList) {
            boolean compareSucess = false;
            if ("ignore".equals(dataUniformityDTO.getDealType())) continue;
            String bk = dataUniformityDTO.getBk();
            JSONObject bkMap = new JSONObject();
            if (bk.startsWith("{") && bk.endsWith("}")) {
                try {
                    bkMap = (JSONObject)JsonUtils.jsonToObject((String)bk, JSONObject.class);
                }
                catch (Exception e) {
                    continue;
                }
            }
            Set bkKeys = bkMap.keySet();
            String bkKeyStr = String.join((CharSequence)";", bkKeys);
            for (Map<String, Object> dataMap : allDataList) {
                boolean isAbnormalData = true;
                Set<String> dataKeys = dataMap.keySet();
                if (!dataKeys.containsAll(bkKeys)) {
                    isAbnormalData = false;
                } else {
                    for (String bkKey : bkKeys) {
                        if (dataMap.get(bkKey).equals(bkMap.get(bkKey))) continue;
                        isAbnormalData = false;
                        break;
                    }
                }
                if (!isAbnormalData) continue;
                compareSucess = true;
                dataMap.put("workitemId", dataUniformityDTO.getCardId());
                dataMap.put("bk", dataUniformityDTO.getBk());
                dataMap.put("bkKeys", bkKeyStr);
                dataMap.put("lastModifyTime", dataUniformityDTO.getLastModifyTime());
                dataMap.put("optType", dataUniformityDTO.getOptType());
                dataMap.put("dealType", dataUniformityDTO.getDealType());
                dataMap.put("entityName", dataUniformityDTO.getEntityName());
                if (dataUniformityDTO.getDifferentData() != null) {
                    JSONObject differentData = dataUniformityDTO.getDifferentData();
                    Map differentMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)differentData), Map.class);
                    for (String key : differentMap.keySet()) {
                        if (!dataKeys.contains(key)) continue;
                        ObjectMapper objectMapper = new ObjectMapper();
                        dataMap.put("new_" + key, objectMapper.convertValue(differentData.get(key), dataMap.get(key).getClass()));
                        dataMap.put("old_" + key, dataMap.get(key));
                    }
                }
                abnormalDataSet.add(dataMap);
            }
        }
        return abnormalDataSet;
    }

    public void recordBkCompleted(AuthoredUser user, Long backlogId, Map<String, Object> requestData, String tmActivityId) {
        try {
            if (backlogId == null || requestData == null || user == null) {
                log.info("backlogId or requestData or user is null");
                return;
            }
            ArrayList<Long> cardIdList = new ArrayList<Long>();
            cardIdList.add(backlogId);
            List bkDataList = this.mongodbService.getBkByCardId(user.getTenantId(), cardIdList);
            if (CollectionUtils.isEmpty((Collection)bkDataList)) {
                return;
            }
            ArrayList submitDataList = new ArrayList();
            for (Map.Entry<String, Object> dataListMap : requestData.entrySet()) {
                Object value = dataListMap.getValue();
                if (!(value instanceof List)) continue;
                submitDataList.addAll((List)dataListMap.getValue());
            }
            ArrayList completedBkList = new ArrayList();
            ArrayList giveupList = new ArrayList();
            log.info("recordBkCompleted.getBpmWorkItemById:{} start", (Object)backlogId);
            Map workitemMap = this.atmcService.getBpmWorkItemById(backlogId);
            log.info("recordBkCompleted.getBpmWorkItemById:{} end", (Object)backlogId);
            log.info("recordBkCompleted.compare bk data start");
            for (Map submitData : submitDataList) {
                Set submitFieldSet = submitData.keySet();
                for (Map bkDataMap : bkDataList) {
                    Set bkKeys;
                    boolean isSame = true;
                    DataUniformityDTO dataUniformityDTO = (DataUniformityDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)bkDataMap), DataUniformityDTO.class);
                    String bk = dataUniformityDTO.getBk();
                    JSONObject bkMap = null;
                    if (bk.startsWith("{") && bk.endsWith("}")) {
                        try {
                            bkMap = (JSONObject)JsonUtils.jsonToObject((String)bk, JSONObject.class);
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    if (!submitFieldSet.containsAll(bkKeys = bkMap.keySet())) {
                        isSame = false;
                    } else {
                        for (String bkKey : bkKeys) {
                            if (submitData.get(bkKey).equals(bkMap.get(bkKey))) continue;
                            isSame = false;
                            break;
                        }
                    }
                    if (!isSame) continue;
                    HashMap<String, Object> completedBkMap = new HashMap<String, Object>();
                    completedBkMap.put("bk", dataUniformityDTO.getBk());
                    completedBkMap.put("workitemId", backlogId);
                    completedBkList.add(completedBkMap);
                    HashMap<String, String> sdMap = new HashMap<String, String>();
                    sdMap.put("tenantId", user.getTenantId());
                    sdMap.put("tempId", tmActivityId);
                    sdMap.put("type", "activity");
                    sdMap.put("entityName", (String)bkDataMap.get("entityName"));
                    sdMap.put("bk", (String)bkDataMap.get("bk"));
                    sdMap.put("instanceId", workitemMap.get("activityStepId").toString());
                    giveupList.add(sdMap);
                }
            }
            log.info("recordBkCompleted.compare bk data end");
            log.info("recordBkCompleted.updateCompleted bk data start");
            this.mongodbService.updateCompleted(user.getTenantId(), completedBkList);
            log.info("recordBkCompleted.updateCompleted bk data end");
            if (CollectionUtils.isEmpty(giveupList)) {
                return;
            }
            HashMap<String, String> existParamMap = new HashMap<String, String>();
            existParamMap.put("tenantId", user.getTenantId());
            existParamMap.put("tempId", tmActivityId);
            existParamMap.put("type", "activity");
            existParamMap.put("instanceId", (String)workitemMap.get("activityStepId"));
            existParamMap.put("entityName", (String)((Map)giveupList.get(0)).get("entityName"));
            boolean exist = this.commonSmartDataService.existsComparison(existParamMap);
            log.info("DataUnfiormityProcessor-exist:{}", (Object)exist);
            if (!exist) {
                return;
            }
            HashMap batchGiveMap = new HashMap();
            batchGiveMap.put("taskOperationInputs", giveupList);
            log.info("DataUnfiormityProcessor-batchGiveMap:{}", batchGiveMap);
            this.commonSmartDataService.batchGiveupComparisonData(batchGiveMap);
        }
        catch (Exception e) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace.length > 0) {
                StackTraceElement firstStackTraceElement = stackTrace[0];
                String errorMessage = "\u53d1\u751f\u5f02\u5e38\u5728: " + firstStackTraceElement.getClassName() + " \u7684\u7b2c " + firstStackTraceElement.getLineNumber() + " \u884c\uff1a" + e.getMessage();
                log.error("\u63d0\u4ea4\u65f6\u8bb0\u5f55\u6570\u636e\u5bf9\u5e94\u7684bk\u4e3a\u5df2\u5b8c\u6210\u72b6\u6001\u5e76\u5220\u9664sd\u76f8\u5bf9\u5e94\u7684\u5f02\u6b65\u4efb\u52a1\u62a5\u9519" + errorMessage);
            }
            log.error("\u63d0\u4ea4\u65f6\u8bb0\u5f55\u6570\u636e\u5bf9\u5e94\u7684bk\u4e3a\u5df2\u5b8c\u6210\u72b6\u6001\u5e76\u5220\u9664sd\u76f8\u5bf9\u5e94\u7684\u5f02\u6b65\u4efb\u52a1\u62a5\u9519" + e.getMessage());
        }
    }
}

