package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.dataUniformity.DataUniformityMongodbService;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.DataUniformityDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.AsyncEventBus;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author：SYQ
 * @date：2022/5/13
 */
@Slf4j
@Service
public class DataUnfiormityProcessor {

    @Autowired
    private DataUniformityMongodbService mongodbService;

    @Autowired
    private CommonAtmcService atmcService;

    @Autowired
    private CommonSmartDataService commonSmartDataService;

    @Autowired
    private AsyncEventBus asyncEventBus;

    /**
     * 比对出异动数据
     *
     * @Author：SYQ
     * @Date：2022/5/13 14:35
     */
    public Set<Map<String, Object>> comparisonData(List<Map<String, Object>> allDataList, DataSourceProcessor dataSourceProcessor) {
        //获取异动数据的bk
        List<DataUniformityDTO> abnormalBkList = new ArrayList<>();
        List parasList = (List) dataSourceProcessor.getParas();
        for (Object parasObj : parasList) {
            abnormalBkList.add(JsonUtils.jsonToObject(JsonUtils.objectToString(parasObj), DataUniformityDTO.class));
        }

        if (CollectionUtils.isEmpty(allDataList) || CollectionUtils.isEmpty(abnormalBkList)) {
            return new HashSet<>();
        }
        //异动数据
        Set<Map<String, Object>> abnormalDataSet = new HashSet<>();

        for (DataUniformityDTO dataUniformityDTO : abnormalBkList) {
            boolean compareSucess = false;
            //去掉处理方案为忽略的bk
            if ("ignore".equals(dataUniformityDTO.getDealType())) {
                continue;
            }
            String bk = dataUniformityDTO.getBk();
            JSONObject bkMap = new JSONObject();
            if (bk.startsWith("{") && bk.endsWith("}")) {
                try {
                    bkMap = JsonUtils.jsonToObject(bk, JSONObject.class);
                } catch (Exception e) {
                    continue;
                }
            }
            //bk的key
            Set<String> bkKeys = bkMap.keySet();
            String bkKeyStr = String.join(";", bkKeys);
            //循环业务数据
            for (Map<String, Object> dataMap : allDataList) {
                boolean isAbnormalData = true;
                //业务数据的key
                Set<String> dataKeys = dataMap.keySet();
                //判断bk的key是否全在业务数据的key中
                if (!dataKeys.containsAll(bkKeys)) {
                    isAbnormalData = false;
                } else {
                    for (String bkKey : bkKeys) {
                        if (!dataMap.get(bkKey).equals(bkMap.get(bkKey))) {
                            isAbnormalData = false;
                            break;
                        }
                    }
                }
                if (isAbnormalData) {
                    compareSucess = true;
                    dataMap.put("workitemId", dataUniformityDTO.getCardId());
                    dataMap.put("bk", dataUniformityDTO.getBk());
                    dataMap.put("bkKeys", bkKeyStr);
                    dataMap.put("lastModifyTime", dataUniformityDTO.getLastModifyTime());
                    dataMap.put("optType", dataUniformityDTO.getOptType());
                    dataMap.put("dealType", dataUniformityDTO.getDealType());
                    dataMap.put("entityName", dataUniformityDTO.getEntityName());
                    if (dataUniformityDTO.getDifferentData() != null) {
                        JSONObject differentData = dataUniformityDTO.getDifferentData();
                        Map<String, Object> differentMap = JsonUtils.jsonToObject(JsonUtils.objectToString(differentData), Map.class);
                        for (String key : differentMap.keySet()) {
                            if (dataKeys.contains(key)) {
                                ObjectMapper objectMapper = new ObjectMapper();
                                dataMap.put("new_" + key, objectMapper.convertValue(differentData.get(key), dataMap.get(key).getClass()));
                                dataMap.put("old_" + key, dataMap.get(key));
                            }
                        }
                    }
                    abnormalDataSet.add(dataMap);
                }
            }

        }
        return abnormalDataSet;
    }

    /**
     * 记录数据对应的bk已完成
     *
     * @Author：SYQ
     * @Date：2022/5/31 17:38
     */
    public void recordBkCompleted(AuthoredUser user, Long backlogId, Map<String, Object> requestData, String tmActivityId) {
        try
        {
            if (backlogId == null || requestData == null || user == null) {
                log.info("backlogId or requestData or user is null");
                return;
            }
            //根据任务id查询bk信息
            List<Long> cardIdList = new ArrayList<>();
            cardIdList.add(backlogId);
            List<Map> bkDataList = mongodbService.getBkByCardId(user.getTenantId(), cardIdList);
//            log.info("recordBkCompleted-bkDataList:{}", JsonUtils.objectToString(bkDataList));
            if (CollectionUtils.isEmpty(bkDataList)) {
                return;
            }
            //提交了的数据
            List<Map> submitDataList = new ArrayList<>();
            for (Map.Entry<String, Object> dataListMap : requestData.entrySet()) {
                Object value = dataListMap.getValue();
                if(value instanceof List){
                    submitDataList.addAll((List<Map>) dataListMap.getValue());
                }
            }
//            log.info("recordBkCompleted-requestData:{}", JsonUtils.objectToString(requestData));
//            log.info("recordBkCompleted-submitDataList:{}", JsonUtils.objectToString(submitDataList));
            //需要标记为完成的bk
            List<Map<String, Object>> completedBkList = new ArrayList<>();
            //需要删除的侦测
            List<Map> giveupList = new ArrayList<>();
            /*比对哪个bk需要完成 start*/
            //查询任务信息
            log.info("recordBkCompleted.getBpmWorkItemById:{} start", backlogId);
            Map workitemMap = atmcService.getBpmWorkItemById(backlogId);
            log.info("recordBkCompleted.getBpmWorkItemById:{} end", backlogId);
            //循环提交数据
            log.info("recordBkCompleted.compare bk data start");
            for (Map submitData : submitDataList) {
                //业务数据字段
                Set<String> submitFieldSet = submitData.keySet();
                //循环bk
                for (Map bkDataMap : bkDataList) {
                    //默认需要关闭
                    boolean isSame = true;
                    //转换bk信息
                    DataUniformityDTO dataUniformityDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(bkDataMap), DataUniformityDTO.class);
                    String bk = dataUniformityDTO.getBk();
                    JSONObject bkMap = null;
                    if (bk.startsWith("{") && bk.endsWith("}")) {
                        try {
                            bkMap = JsonUtils.jsonToObject(bk, JSONObject.class);
                        } catch (Exception e) {
                            continue;
                        }
                    }
                    //bk中的字段
                    Set<String> bkKeys = bkMap.keySet();
                    //如果业务数据中不包含bk的字段，匹配不上，则bk不能关闭
                    if (!submitFieldSet.containsAll(bkKeys)) {
                        isSame = false;
                    } else {
                        //循环bk，判断bk的值和业务数据中的值是否一样，如果不一样则不需要关闭
                        for (String bkKey : bkKeys) {
                            if (!submitData.get(bkKey).equals(bkMap.get(bkKey))) {
                                isSame = false;
                                break;
                            }
                        }
                    }

                    if (isSame) {
                        Map<String, Object> completedBkMap = new HashMap<>();
                        completedBkMap.put("bk", dataUniformityDTO.getBk());
                        completedBkMap.put("workitemId", backlogId);
                        completedBkList.add(completedBkMap);

                        Map<String, Object> sdMap = new HashMap<>();
                        sdMap.put("tenantId", user.getTenantId());
                        sdMap.put("tempId", tmActivityId);
                        sdMap.put("type", "activity");
                        sdMap.put("entityName", bkDataMap.get("entityName"));
                        sdMap.put("bk", bkDataMap.get("bk"));
                        sdMap.put("instanceId", workitemMap.get("activityStepId").toString());
                        giveupList.add(sdMap);
                    }

                }
            }
            log.info("recordBkCompleted.compare bk data end");
            /*比对哪个bk需要完成 end*/
            //标记数据已完成
            log.info("recordBkCompleted.updateCompleted bk data start");
            mongodbService.updateCompleted(user.getTenantId(), completedBkList);
            log.info("recordBkCompleted.updateCompleted bk data end");

            /*删除侦测 start*/
//            log.info("DataUnfiormityProcessor-giveupList:{}", giveupList);
            if (CollectionUtils.isEmpty(giveupList)) {
                return;
            }
            // 获取比对任务是否存在参数
            Map<String, Object> existParamMap = new HashMap<>();
            existParamMap.put("tenantId", user.getTenantId());
            existParamMap.put("tempId", tmActivityId);
            existParamMap.put("type", "activity");
            existParamMap.put("instanceId", workitemMap.get("activityStepId"));
            existParamMap.put("entityName", giveupList.get(0).get("entityName"));
//            log.info("DataUnfiormityProcessor-existParamMap:{}", JsonUtils.objectToString(existParamMap));
            // 获取比对任务是否存在
            boolean exist = commonSmartDataService.existsComparison(existParamMap);
            log.info("DataUnfiormityProcessor-exist:{}", exist);
            // 如果没有比对任务则不做放弃操作
            if (!exist) {
                return;
            }
            // 批量删除数据
            Map<String, Object> batchGiveMap = new HashMap<>();
            batchGiveMap.put("taskOperationInputs", giveupList);
            log.info("DataUnfiormityProcessor-batchGiveMap:{}", batchGiveMap);
            commonSmartDataService.batchGiveupComparisonData(batchGiveMap);
            /*删除侦测 end*/
        }
        catch (Exception e)
        {
            StackTraceElement[] stackTrace = e.getStackTrace();
            //优化日志报错
            if (stackTrace.length > 0) {
                StackTraceElement firstStackTraceElement = stackTrace[0];
                String errorMessage = "发生异常在: " + firstStackTraceElement.getClassName() +
                        " 的第 " + firstStackTraceElement.getLineNumber() + " 行：" + e.getMessage();
                // 使用日志框架记录 errorMessage
                log.error("提交时记录数据对应的bk为已完成状态并删除sd相对应的异步任务报错" + errorMessage );
            } else {
                // 如果没有堆栈跟踪信息，只记录异常消息
                log.error("提交时记录数据对应的bk为已完成状态并删除sd相对应的异步任务报错" + e.getMessage());
            }
        }
    }
}
