/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class LeftJoinDataSource
extends DataSourceBase {
    private DataSourceBase left;
    private Boolean override = false;
    private List<DataSourceBase> rightList;

    @Override
    public QueryAction getAction() {
        if (this.left == null) {
            return null;
        }
        return this.left.getAction();
    }

    @Override
    public String getActionId() {
        if (this.getAction() != null) {
            return this.getAction().getActionId();
        }
        return "";
    }

    public LeftJoinDataSource() {
        this.setType("MIX_LEFT_JOIN");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (this.left == null) {
            return QueryResult.empty((String)this.getName());
        }
        QueryResult mainResult = this.left.query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
        mainResult.setDataSourceName(this.getName());
        if (mainResult.getData().size() == 0) {
            return mainResult;
        }
        if (CollectionUtils.isEmpty(this.rightList)) {
            return mainResult;
        }
        if (CollectionUtils.isEmpty(this.left.getDataKeys())) {
            return mainResult;
        }
        for (DataSourceBase dataSourceBase : this.rightList) {
            QueryResult result = dataSourceBase.query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
            if (result.size() == 0) continue;
            HashMap rightGroup = new HashMap();
            StringBuilder keyBuilder = new StringBuilder();
            for (Map datum : result.getData()) {
                keyBuilder.setLength(0);
                for (String key : this.left.getDataKeys()) {
                    if (!datum.containsKey(key)) continue;
                    keyBuilder.append(datum.get(key) == null ? "NAN" : datum.get(key).toString()).append(";");
                }
                if (keyBuilder.length() == 0) continue;
                String key = keyBuilder.toString();
                if (!rightGroup.containsKey(key)) {
                    ArrayList<Map> dataRows = new ArrayList<Map>();
                    dataRows.add(datum);
                    rightGroup.put(key, dataRows);
                    continue;
                }
                ((List)rightGroup.get(key)).add(datum);
            }
            ArrayList<Map> newResult = new ArrayList<Map>();
            for (Map datum : mainResult.getData()) {
                String mainKey = datum.getOrDefault("__DATA_KEY", "").toString();
                if (mainKey.length() > 0 && rightGroup.containsKey(mainKey)) {
                    for (Map stringObjectMap : (List)rightGroup.get(mainKey)) {
                        for (Map.Entry stringObjectEntry : datum.entrySet()) {
                            if (this.override.booleanValue()) {
                                if (stringObjectMap.containsKey(stringObjectEntry.getKey())) continue;
                                stringObjectMap.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                                continue;
                            }
                            stringObjectMap.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                        }
                        newResult.add(stringObjectMap);
                    }
                    continue;
                }
                newResult.add(datum);
            }
            mainResult.resetData(newResult);
        }
        mainResult.setDataKeys(this.left.getDataKeys());
        mainResult.initializeDataKey();
        return mainResult;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        if (queryResult.getData().size() == 0) {
            return null;
        }
        ApiMetadataCollection apiMetadataCollection = this.left.queryMetaData(executeContext, parameter, queryResult);
        if (CollectionUtils.isEmpty(this.rightList)) {
            return apiMetadataCollection;
        }
        for (DataSourceBase dataSourceBase : this.rightList) {
            ApiMetadataCollection metadataCollection = dataSourceBase.queryMetaData(executeContext, parameter, queryResult);
            if (metadataCollection == null || metadataCollection.getMasterApiMetadata() == null || metadataCollection.getMasterApiMetadata().getResponseFields().size() <= 0) continue;
            apiMetadataCollection.getMasterApiMetadata().addResponseFields(((MetadataField)metadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields());
        }
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        LeftJoinDataSource mergeDataSource = new LeftJoinDataSource();
        mergeDataSource.setName(this.getName());
        mergeDataSource.setAction(this.getAction());
        mergeDataSource.setType(this.getType());
        mergeDataSource.setDataKeys(this.getDataKeys());
        mergeDataSource.setActionId(this.getActionId());
        if (this.left != null) {
            mergeDataSource.setLeft(this.left.copyWithoutProcessor());
        }
        if (CollectionUtils.isNotEmpty(this.rightList)) {
            ArrayList<DataSourceBase> dataSourceBases = new ArrayList<DataSourceBase>();
            for (DataSourceBase dataSourceBase : this.rightList) {
                dataSourceBases.add(dataSourceBase.copyWithoutProcessorCore());
            }
            mergeDataSource.setRightList(dataSourceBases);
        }
        return mergeDataSource;
    }

    public DataSourceBase getLeft() {
        return this.left;
    }

    public Boolean getOverride() {
        return this.override;
    }

    public List<DataSourceBase> getRightList() {
        return this.rightList;
    }

    public void setLeft(DataSourceBase left) {
        this.left = left;
    }

    public void setOverride(Boolean override) {
        this.override = override;
    }

    public void setRightList(List<DataSourceBase> rightList) {
        this.rightList = rightList;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeftJoinDataSource)) {
            return false;
        }
        LeftJoinDataSource other = (LeftJoinDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSourceBase this$left = this.getLeft();
        DataSourceBase other$left = other.getLeft();
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        Boolean this$override = this.getOverride();
        Boolean other$override = other.getOverride();
        if (this$override == null ? other$override != null : !((Object)this$override).equals(other$override)) {
            return false;
        }
        List<DataSourceBase> this$rightList = this.getRightList();
        List<DataSourceBase> other$rightList = other.getRightList();
        return !(this$rightList == null ? other$rightList != null : !((Object)this$rightList).equals(other$rightList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LeftJoinDataSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSourceBase $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        Boolean $override = this.getOverride();
        result = result * 59 + ($override == null ? 43 : ((Object)$override).hashCode());
        List<DataSourceBase> $rightList = this.getRightList();
        result = result * 59 + ($rightList == null ? 43 : ((Object)$rightList).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "LeftJoinDataSource(left=" + this.getLeft() + ", override=" + this.getOverride() + ", rightList=" + this.getRightList() + ")";
    }
}

