/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

public class MergeDataSource
extends DataSourceBase {
    private Boolean override;
    private DataSourceBase left;
    private List<DataSourceBase> rightList;

    @Override
    public QueryAction getAction() {
        if (this.left == null) {
            return null;
        }
        return this.left.getAction();
    }

    @Override
    public String getActionId() {
        if (this.getAction() != null) {
            return this.getAction().getActionId();
        }
        return "";
    }

    public MergeDataSource() {
        this.setType("MIX_MERGE");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (this.left == null) {
            return QueryResult.empty((String)this.getName());
        }
        QueryResult mainResult = this.left.query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
        mainResult.setDataSourceName(this.getName());
        if (mainResult.getData().size() == 0) {
            return mainResult;
        }
        if (CollectionUtils.isEmpty(this.rightList)) {
            return mainResult;
        }
        for (DataSourceBase dataSourceBase : this.rightList) {
            QueryResult result = dataSourceBase.query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
            if (result.size() == 0) continue;
            if (CollectionUtils.isNotEmpty(dataSourceBase.getDataKeys()) && CollectionUtils.isNotEmpty(this.left.getDataKeys())) {
                if (StringUtils.collectionToCommaDelimitedString(dataSourceBase.getDataKeys()).equals(StringUtils.collectionToCommaDelimitedString(this.left.getDataKeys()))) {
                    for (Map datum : mainResult.getData()) {
                        String key = datum.getOrDefault("__DATA_KEY", "").toString();
                        Map findItem = result.findByKey(key);
                        if (findItem == null) continue;
                        for (Map.Entry stringObjectEntry : findItem.entrySet()) {
                            if (datum.containsKey(stringObjectEntry.getKey())) continue;
                            datum.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                        }
                    }
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (Map datum : mainResult.getData()) {
                    String key;
                    Map findItem;
                    stringBuilder.setLength(0);
                    for (String key2 : dataSourceBase.getDataKeys()) {
                        if (!datum.containsKey(key2)) continue;
                        stringBuilder.append(datum.get(key2) == null ? "NAN" : datum.get(key2).toString()).append(";");
                    }
                    if (stringBuilder.length() <= 0 || (findItem = result.findByKey(key = stringBuilder.toString())) == null) continue;
                    for (Map.Entry stringObjectEntry : findItem.entrySet()) {
                        if (datum.containsKey(stringObjectEntry.getKey())) continue;
                        datum.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                    }
                }
                continue;
            }
            MessageUtils messageUtils = (MessageUtils)SpringUtil.getBean(MessageUtils.class);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0044.getErrCode(), (String)messageUtils.getMessage("exception.define.data.primary.key"));
        }
        return mainResult;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        if (queryResult.getData() != null && queryResult.getData().size() == 0) {
            return null;
        }
        ApiMetadataCollection apiMetadataCollection = this.left.queryMetaData(executeContext, parameter, queryResult);
        if (CollectionUtils.isEmpty(this.rightList)) {
            return apiMetadataCollection;
        }
        for (DataSourceBase dataSourceBase : this.rightList) {
            ApiMetadataCollection metadataCollection = dataSourceBase.queryMetaData(executeContext, parameter, queryResult);
            if (metadataCollection == null || metadataCollection.getMasterApiMetadata() == null || metadataCollection.getMasterApiMetadata().getResponseFields().size() <= 0) continue;
            apiMetadataCollection.getMasterApiMetadata().addResponseFields(((MetadataField)metadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields());
        }
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        MergeDataSource mergeDataSource = new MergeDataSource();
        mergeDataSource.setName(this.getName());
        mergeDataSource.setAction(this.getAction());
        mergeDataSource.setType(this.getType());
        mergeDataSource.setDataKeys(this.getDataKeys());
        mergeDataSource.setActionId(this.getActionId());
        if (this.left != null) {
            mergeDataSource.setLeft(this.left.copyWithoutProcessor());
        }
        if (CollectionUtils.isNotEmpty(this.rightList)) {
            ArrayList<DataSourceBase> dataSourceBases = new ArrayList<DataSourceBase>();
            for (DataSourceBase dataSourceBase : this.rightList) {
                dataSourceBases.add(dataSourceBase.copyWithoutProcessorCore());
            }
            mergeDataSource.setRightList(dataSourceBases);
        }
        return mergeDataSource;
    }

    public Boolean getOverride() {
        return this.override;
    }

    public DataSourceBase getLeft() {
        return this.left;
    }

    public List<DataSourceBase> getRightList() {
        return this.rightList;
    }

    public void setOverride(Boolean override) {
        this.override = override;
    }

    public void setLeft(DataSourceBase left) {
        this.left = left;
    }

    public void setRightList(List<DataSourceBase> rightList) {
        this.rightList = rightList;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeDataSource)) {
            return false;
        }
        MergeDataSource other = (MergeDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$override = this.getOverride();
        Boolean other$override = other.getOverride();
        if (this$override == null ? other$override != null : !((Object)this$override).equals(other$override)) {
            return false;
        }
        DataSourceBase this$left = this.getLeft();
        DataSourceBase other$left = other.getLeft();
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        List<DataSourceBase> this$rightList = this.getRightList();
        List<DataSourceBase> other$rightList = other.getRightList();
        return !(this$rightList == null ? other$rightList != null : !((Object)this$rightList).equals(other$rightList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MergeDataSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $override = this.getOverride();
        result = result * 59 + ($override == null ? 43 : ((Object)$override).hashCode());
        DataSourceBase $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        List<DataSourceBase> $rightList = this.getRightList();
        result = result * 59 + ($rightList == null ? 43 : ((Object)$rightList).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MergeDataSource(override=" + this.getOverride() + ", left=" + this.getLeft() + ", rightList=" + this.getRightList() + ")";
    }
}

