/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.thememap.CommonThemeMapService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class TmFormulaDataSource
extends DataSourceBase {
    public TmFormulaDataSource() {
        this.setType("TM");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (this.getAction() == null) {
            return QueryResult.empty((String)this.getName());
        }
        if (this.getAction().getParas() == null) {
            return QueryResult.empty((String)this.getName());
        }
        Map map = this.getAction().getParas();
        String formulaId = map.get("formulaId").toString();
        if (StringUtils.isEmpty((Object)formulaId)) {
            return QueryResult.empty((String)this.getName());
        }
        HashMap formulaMap = ((CommonThemeMapService)SpringUtil.getBean(CommonThemeMapService.class)).executeFormula(formulaId);
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        list.add(formulaMap);
        HashMap<String, ArrayList<HashMap>> espData = new HashMap<String, ArrayList<HashMap>>();
        espData.put("response", list);
        QueryResult queryResult = QueryResult.withData((String)this.getName(), espData);
        return queryResult;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        return null;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        TmFormulaDataSource tmDataSource = new TmFormulaDataSource();
        tmDataSource.setName(this.getName());
        tmDataSource.setAction(this.getAction());
        tmDataSource.setType(this.getType());
        tmDataSource.setDataKeys(this.getDataKeys());
        tmDataSource.setActionId(this.getActionId());
        return tmDataSource;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TmFormulaDataSource)) {
            return false;
        }
        TmFormulaDataSource other = (TmFormulaDataSource)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TmFormulaDataSource;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "TmFormulaDataSource()";
    }
}

