/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.cache.CacheManager;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.datasource.BuildPageDataProcessService;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.esp.CommonESPService;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appendGlobalParameterService")
public class AppendGlobalParameterService
implements BuildPageDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AppendGlobalParameterService.class);
    @Autowired
    private CommonESPService commonEspService;
    @Autowired
    private CacheManager cacheManager;

    public void handelPageData(ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResultSet queryResultSet) {
        if (!"task-detail".equals(executeContext.getPageCode()) && !"project-detail".equals(executeContext.getPageCode())) {
            return;
        }
        if (queryResultSet == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)queryResultSet.getQueryResults())) {
            return;
        }
        try {
            String cacheKey = executeContext.getTenantId() + ":system.parameter.data.get";
            String json = (String)this.cacheManager.get("atdm:cache:", (Object)cacheKey);
            if (json != null) {
                HashMap params = (HashMap)JsonUtils.jsonToObject((String)json, HashMap.class);
                QueryResult queryResult = QueryResult.withSingleData((String)"uibot__global_parameter", (Map)params);
                queryResultSet.appendData(queryResult);
            } else {
                HashMap params = this.commonEspService.queryByApiName(executeContext, "system.parameter.data.get", null, null, null, null);
                if (params == null || MapUtils.isEmpty((Map)params) || params.containsKey("")) {
                    return;
                }
                this.cacheManager.cache("atdm:cache:", (Object)cacheKey, (Object)JsonUtils.objectToString((Object)params), Duration.ofMinutes(30L));
                QueryResult queryResult = QueryResult.withSingleData((String)"uibot__global_parameter", (Map)params);
                queryResultSet.appendData(queryResult);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

