package com.digiwin.athena.atdm.datasource;


import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.dto.DataQueryDTO;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.digiwin.athena.atdm.datasource.dto.DataSourceSetDTO;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;

import java.util.List;
import java.util.Map;

public interface DataFetchingService {
    /**
     * 查询数据和元数据
     * @param executeContext 上下文
     * @param parameter
     * @return
     */
    QueryResultSet queryWithMetaData(ExecuteContext executeContext, DataSourceSetDTO dataSourceSetDTO, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo);

    /**
     * 查询总行数
     * @param executeContext
     * @param parameter
     * @return
     */
    int size(ExecuteContext executeContext, DataSourceDTO dataSourceDTO, Map<String, Object> parameter, String sizeType);

    /**
     * 查询总行数
     *
     * @param dataQuery  查询参数
     * @return 总行数
     */
    int size(DataQueryDTO dataQuery);

    /**
     * 查询总行数
     *
     * @param dataQuery  查询参数
     * @param dataSource 查询数据源
     * @return 总行数
     */
    int size(DataQueryDTO dataQuery, DataSourceDTO dataSource);

    /**
     * 查询数据
     * @param executeContext 上下文
     * @param parameter
     * @return
     */
    QueryResultSet query(ExecuteContext executeContext, DataSourceSetDTO dataSourceSetDTO,  Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo);

    /**
     * 查询单一数据源数据和元数据
     * @param executeContext 上下文
     * @param parameter
     * @return
     */
    QueryResult querySingleResultWithMetaData(ExecuteContext executeContext, DataSourceDTO dataSourceDTO,  Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo);

    /**
     * 查询单一数据
     * @param executeContext
     * @param parameter
     * @return
     */
    QueryResult querySingleResult(ExecuteContext executeContext, DataSourceDTO dataSourceDTO,  Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo);
    /**
     * 获取数据个数（内含异动数据个数）
     * @Author：SYQ
     * @Date：2022/5/23 15:39
     */
    Map<String,Integer> getDataSize(ExecuteContext executeContext, DataSourceDTO dataSourceDTO, Map<String, Object> parameter, String sizeType);

    /**
     * 查询出数据后整理结果
     * @Author：SYQ
     * @Date：2022/5/25 13:32
     */
    void dealQueryResult(QueryResultSet  queryResult, DataSourceProcessor dataSourceProcessor);

    /**
     * 判断需不需要走异动数据逻辑
     * @Author：SYQ
     * @Date：2022/5/25 13:32
     */
    DataSourceProcessor judgeAbnormalProcessor(DataQueryDTO dataQueryDTO);

    void queryInfo(DataQueryDTO dataQueryDTO,QueryResultSet queryResultSet,Map result);

    void dealDataQueryInfoBeforeQuery(DataQueryDTO dataQuery);

    void dealPageDataAfterQuery(DataQueryDTO dataQuery, QueryResultSet queryResultSet, Map result);
}
