package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.activity.domain.AttachmentConfig;
import com.digiwin.athena.atdm.activity.domain.AttachmentConfigInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * 附件工具类
 *
 * @author majfa
 * @date 2020.11.25
 * @since [迭代10-附件]
 */
public abstract class AttachmentUtil {
    public static boolean isPageCodeEnableAttachment(String pageCode) {
        if (ActivityConstants.TASK_DETAIL.equals(pageCode)
                || ActivityConstants.PROJECT_DETAIL.equals(pageCode)
                || ActivityConstants.BASIC_DATA.equals(pageCode)) {
            return true;
        }

        return false;
    }

    public static boolean sourceTypeEnableAttachment(String type) {
        return !UiBotConstants.ACTION_CATEGORY_SHELVED_DATA.equals(type);
    }

    /**
     * 获取用于查询附件的目录列表
     *
     * @param attachmentConfigInfo TM.activityConfigs中配置的附件信息
     * @return
     */
    public static List<String> getQueryCategories(AttachmentConfig attachmentConfigInfo) {
        if (null == attachmentConfigInfo) {
            return Collections.emptyList();
        }

        Set<String> categories = Sets.newHashSet();
        if (StringUtils.isNotBlank(attachmentConfigInfo.getUploadCategory())) {
            categories.add(attachmentConfigInfo.getUploadCategory());
        }

        if (ArrayUtils.isNotEmpty(attachmentConfigInfo.getReadCategory())) {
            categories.addAll(Arrays.asList(attachmentConfigInfo.getReadCategory()));
        }

        return Lists.newArrayList(categories);
    }

    public static AttachmentConfigInfo toAttachment(Object param) {
        if (null == param) {
            return new AttachmentConfigInfo();
        }

        if (param instanceof AttachmentConfigInfo) {
            return (AttachmentConfigInfo) param;
        } else {
            return JsonUtils.jsonToObject(JsonUtils.objectToString(param), AttachmentConfigInfo.class);
        }
    }
}
