/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.BuildPageDataProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.ParallelQueryTaskUtils;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.dto.DataStatus;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceSet {
    private Logger logger = LoggerFactory.getLogger(DataSourceSet.class);
    public static final Map<String, Object> COMMON_FIELD_MAP = MapUtil.builder(new HashMap()).put((Object)"uibot_data_status", (Object)"not-changed").build();
    private List<DataSourceBase> dataSourceList;
    private String mainDatasource;
    private List<DataSourceProcessor> dataProcess;

    public static DataSourceSet create(DataSourceBase dataSourceBase) {
        DataSourceSet dataSourceSet = new DataSourceSet();
        ArrayList<DataSourceBase> dataSourceList = new ArrayList<DataSourceBase>();
        dataSourceList.add(dataSourceBase);
        dataSourceSet.setDataSourceList(dataSourceList);
        return dataSourceSet;
    }

    public DataSourceSet append(DataSourceBase dataSourceBase) {
        if (this.dataSourceList == null) {
            this.dataSourceList = new ArrayList<DataSourceBase>();
        }
        this.dataSourceList.add(dataSourceBase);
        return this;
    }

    public QueryResultSet queryWithMetaData(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (CollectionUtils.isEmpty(this.dataSourceList)) {
            return QueryResultSet.empty();
        }
        ArrayList<QueryResult> queryResults = new ArrayList<QueryResult>();
        if (this.dataSourceList.size() == 1) {
            queryResults.add(this.dataSourceList.get(0).queryWithMetaData(executeContext, parameter, pageInfo, sortInfo, searchInfo));
        } else {
            try {
                queryResults = ParallelQueryTaskUtils.queryWithMetaData(executeContext, parameter, this.dataSourceList, pageInfo, sortInfo, searchInfo);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (e.getCause() instanceof BusinessException) {
                    throw (BusinessException)e.getCause();
                }
                this.logger.error("\u591a\u7ebf\u7a0b\u5904\u7406\u51fa\u95ee\u9898:", (Throwable)e);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0047.getErrCode(), (String)"\u591a\u7ebf\u7a0b\u5904\u7406\u51fa\u95ee\u9898", (Throwable)e);
            }
        }
        QueryResultSet queryResultSet = this.getQueryResultSet(executeContext, queryResults);
        return queryResultSet;
    }

    public QueryResultSet query(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (CollectionUtils.isEmpty(this.dataSourceList)) {
            return QueryResultSet.empty();
        }
        ArrayList<QueryResult> queryResults = new ArrayList<QueryResult>();
        if (this.dataSourceList.size() == 1) {
            queryResults.add(this.dataSourceList.get(0).query(executeContext, parameter, pageInfo, sortInfo, searchInfo));
        } else {
            try {
                queryResults = ParallelQueryTaskUtils.query(executeContext, parameter, this.dataSourceList, pageInfo, sortInfo, searchInfo);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (e.getCause() instanceof BusinessException) {
                    throw (BusinessException)e.getCause();
                }
                this.logger.error("\u591a\u7ebf\u7a0b\u5904\u7406\u51fa\u95ee\u9898:", (Throwable)e);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0046.getErrCode(), (String)"\u591a\u7ebf\u7a0b\u5904\u7406\u51fa\u95ee\u9898", (Throwable)e);
            }
        }
        QueryResultSet queryResultSet = this.getQueryResultSet(executeContext, queryResults);
        return queryResultSet;
    }

    private QueryResultSet getQueryResultSet(ExecuteContext executeContext, List<QueryResult> queryResults) {
        Integer appType;
        QueryResultSet queryResultSet = QueryResultSet.withData((String)this.mainDatasource, queryResults);
        if (CollectionUtils.isNotEmpty(this.dataProcess)) {
            for (DataSourceProcessor dataSourceProcessor : this.dataProcess) {
                if (!"executeCompleted".equals(dataSourceProcessor.getActivePoint())) continue;
                BuildPageDataProcessService buildPageDataProcessService = (BuildPageDataProcessService)SpringUtil.tryGetBean((String)dataSourceProcessor.getServiceName());
                buildPageDataProcessService.handelPageData(executeContext, dataSourceProcessor, queryResultSet);
            }
        }
        Integer n = appType = null != executeContext ? executeContext.getAppType() : null;
        if (null != appType && appType == 5) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            String key = Optional.ofNullable(executeContext.getDataStatus()).map(DataStatus::getKey).orElse(null);
            boolean isCopy = "copy".equals(executeContext.getEditType());
            String value = Optional.ofNullable(executeContext.getDataStatus()).map(ds -> isCopy ? ds.getNewData() : ds.getNotChanged()).orElse(null);
            if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
                fieldMap.put(key, value);
            }
            DataSourceSet.appendCommonField4Two(queryResultSet.getPageData(), fieldMap);
        } else {
            this.appendCommonField(queryResultSet.getPageData());
        }
        return queryResultSet;
    }

    private void appendCommonField(Map<String, Object> pageData) {
        if (MapUtils.isEmpty(pageData)) {
            return;
        }
        for (Object dataList : pageData.values()) {
            if (dataList instanceof List) {
                List rowDataList = (List)dataList;
                for (Object rowData : rowDataList) {
                    Map rowDataMap = (Map)rowData;
                    rowDataMap.putAll(COMMON_FIELD_MAP);
                }
                continue;
            }
            if (!(dataList instanceof Map)) continue;
            Map rowDataMap = (Map)dataList;
            rowDataMap.putAll(COMMON_FIELD_MAP);
        }
    }

    private static void appendCommonField4Two(Map<String, Object> pageData, Map<String, Object> fieldMap) {
        if (MapUtils.isEmpty(pageData)) {
            return;
        }
        Map<String, Object> effectiveFieldMap = MapUtils.isNotEmpty(fieldMap) ? fieldMap : COMMON_FIELD_MAP;
        for (Object data : pageData.values()) {
            DataSourceSet.processData(data, effectiveFieldMap);
        }
    }

    private static void processData(Object data, Map<String, Object> effectiveFieldMap) {
        block5: {
            block4: {
                if (!(data instanceof Map)) break block4;
                Map mapData = (Map)data;
                mapData.putAll(effectiveFieldMap);
                for (Object value : mapData.values()) {
                    if (!(value instanceof List)) continue;
                    DataSourceSet.processData(value, effectiveFieldMap);
                }
                break block5;
            }
            if (!(data instanceof List)) break block5;
            for (Object item : (List)data) {
                if (item instanceof Map) {
                    Map mapItem = (Map)item;
                    mapItem.putAll(effectiveFieldMap);
                    for (Object innerValue : mapItem.values()) {
                        if (!(innerValue instanceof List)) continue;
                        DataSourceSet.processData(innerValue, effectiveFieldMap);
                    }
                    continue;
                }
                if (!(item instanceof List)) continue;
                DataSourceSet.processData(item, effectiveFieldMap);
            }
        }
    }

    @JsonIgnore
    public String getFirstActionId() {
        if (CollectionUtils.isEmpty(this.dataSourceList)) {
            return null;
        }
        return this.dataSourceList.get(0).getActionId();
    }

    @JsonIgnore
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.dataSourceList);
    }

    @JsonIgnore
    public DataSourceBase getFirstDataQuery() {
        if (CollectionUtils.isEmpty(this.dataSourceList)) {
            return null;
        }
        return this.dataSourceList.get(0);
    }

    @JsonIgnore
    public QueryAction getFirstAction() {
        if (CollectionUtils.isEmpty(this.dataSourceList)) {
            return null;
        }
        return this.dataSourceList.get(0).getAction();
    }

    @Generated
    public DataSourceSet() {
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public List<DataSourceBase> getDataSourceList() {
        return this.dataSourceList;
    }

    @Generated
    public String getMainDatasource() {
        return this.mainDatasource;
    }

    @Generated
    public List<DataSourceProcessor> getDataProcess() {
        return this.dataProcess;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Generated
    public void setDataSourceList(List<DataSourceBase> dataSourceList) {
        this.dataSourceList = dataSourceList;
    }

    @Generated
    public void setMainDatasource(String mainDatasource) {
        this.mainDatasource = mainDatasource;
    }

    @Generated
    public void setDataProcess(List<DataSourceProcessor> dataProcess) {
        this.dataProcess = dataProcess;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceSet)) {
            return false;
        }
        DataSourceSet other = (DataSourceSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        List<DataSourceBase> this$dataSourceList = this.getDataSourceList();
        List<DataSourceBase> other$dataSourceList = other.getDataSourceList();
        if (this$dataSourceList == null ? other$dataSourceList != null : !((Object)this$dataSourceList).equals(other$dataSourceList)) {
            return false;
        }
        String this$mainDatasource = this.getMainDatasource();
        String other$mainDatasource = other.getMainDatasource();
        if (this$mainDatasource == null ? other$mainDatasource != null : !this$mainDatasource.equals(other$mainDatasource)) {
            return false;
        }
        List<DataSourceProcessor> this$dataProcess = this.getDataProcess();
        List<DataSourceProcessor> other$dataProcess = other.getDataProcess();
        return !(this$dataProcess == null ? other$dataProcess != null : !((Object)this$dataProcess).equals(other$dataProcess));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataSourceSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        List<DataSourceBase> $dataSourceList = this.getDataSourceList();
        result = result * 59 + ($dataSourceList == null ? 43 : ((Object)$dataSourceList).hashCode());
        String $mainDatasource = this.getMainDatasource();
        result = result * 59 + ($mainDatasource == null ? 43 : $mainDatasource.hashCode());
        List<DataSourceProcessor> $dataProcess = this.getDataProcess();
        result = result * 59 + ($dataProcess == null ? 43 : ((Object)$dataProcess).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataSourceSet(logger=" + this.getLogger() + ", dataSourceList=" + this.getDataSourceList() + ", mainDatasource=" + this.getMainDatasource() + ", dataProcess=" + this.getDataProcess() + ")";
    }
}

