/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.CountItemData;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="countItemService")
public class CountItemsServiceSource
implements DataSourceProcessService {
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        this.addCountItemsFiled(queryResult.getApiMetadataCollection(), executeContext.getPageCode());
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (dataSourceProcessor.getParas() != null) {
            Map paras = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)dataSourceProcessor.getParas()), (TypeReference)new TypeReference<Map<String, List<CountItemData>>>(){});
            List countItems = (List)paras.get("countItems");
            this.addCountItemsData(countItems, queryResult.getData());
        }
    }

    private void addCountItemsData(List<CountItemData> countItems, List<Map<String, Object>> apiData) {
        if (CollectionUtils.isEmpty(apiData)) {
            return;
        }
        for (Map<String, Object> datum : apiData) {
            ArrayList checkDataList = new ArrayList();
            for (CountItemData countItemData : countItems) {
                HashMap<String, String> checkData = new HashMap<String, String>();
                if (!datum.containsKey(countItemData.getKey())) continue;
                checkData.put("key", countItemData.getKey());
                checkData.put("name", countItemData.getName());
                checkData.put("value", countItemData.getValue());
                checkDataList.add(checkData);
            }
            datum.put("count_result", checkDataList);
        }
    }

    private void addCountItemsFiled(ApiMetadataCollection apiMetadataCollection, String pageCode) {
        if (apiMetadataCollection == null) {
            return;
        }
        MetadataField metadataField = new MetadataField();
        metadataField.setArray(Boolean.valueOf(true));
        metadataField.setUiBot("Y");
        metadataField.setName("count_result");
        if ("task-detail".equals(pageCode) || "project-detail".equals(pageCode)) {
            metadataField.setTagDefinitions(CustomizeTagUtils.createOrderTagDefinitions("999"));
        }
        metadataField.setDescription(this.messageUtils.getMessage("uibot.acitivity.count.check.title"));
        metadataField.setDataType("object");
        ArrayList<MetadataField> subFields = new ArrayList<MetadataField>();
        MetadataField keyMetadataField = new MetadataField();
        keyMetadataField.setArray(Boolean.valueOf(false));
        keyMetadataField.setUiBot("Y");
        keyMetadataField.setName("key");
        keyMetadataField.setDataType("string");
        subFields.add(keyMetadataField);
        MetadataField valueMetadataField = new MetadataField();
        valueMetadataField.setArray(Boolean.valueOf(false));
        valueMetadataField.setUiBot("Y");
        valueMetadataField.setName("value");
        valueMetadataField.setDataType("string");
        subFields.add(valueMetadataField);
        MetadataField nameMetadataField = new MetadataField();
        nameMetadataField.setArray(Boolean.valueOf(false));
        nameMetadataField.setUiBot("Y");
        nameMetadataField.setName("name");
        nameMetadataField.setDataType("string");
        subFields.add(nameMetadataField);
        metadataField.setSubFields(subFields);
        ((MetadataField)apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields().add(metadataField);
    }
}

