package com.digiwin.athena.atdm.datasource.datasource;


import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.constant.Variables;
import com.digiwin.athena.atdm.datasource.res.DesensitizationFieldsRes;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.datasource.domain.*;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.util.SearchInfoUtil;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class EspDataSource  extends DataSourceBase {


    public  EspDataSource(){
        super();
        this.setType(UiBotConstants.ACTION_CATEGORY_ESP);
    }

    @Override
    protected QueryResult  queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo) {
        if (this.getAction() == null){
            return QueryResult.empty(this.getName());
        }
        // 单身/子单身分页保存上次请求参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("parameter", parameter);
        paramMap.put("pageInfo", pageInfo);
        paramMap.put("sortInfo", sortInfo);
        paramMap.put("searchInfo", searchInfo);

        Map paras = this.getAction().getParas();
        //处理分页信息
        if (pageInfo != null){
            if (!pageInfo.isNextAllData()){
                paras.put("use_has_next", true);
                if (pageInfo.getPageSize() != null) {
                    paras.put("page_size", pageInfo.getPageSize());
                }
                if (pageInfo.getPageNo() != null) {
                    paras.put("page_no", pageInfo.getPageNo());
                }
            }
            // 单身/子单身 分页信息
            List<DetailPageInfo> detailPageInfo = pageInfo.getDetailPageInfo();
            if (CollectionUtils.isNotEmpty(detailPageInfo)) {
                // 对象转换为标准api 入参
                List<Map<String, Object>> mapList = detailPageInfo.stream().map(o -> {
                    Map<String, Object> map = new HashMap<>();
                    map.put("page_no", o.getPageNo());
                    map.put("page_size", o.getPageSize());
                    map.put("use_has_next", o.getUseHasNext());
                    map.put("detail_name", o.getDetailName());
                    map.put("detail_path", o.getDetailPath());
                    return map;
                }).collect(Collectors.toList());
                paras.put("detail_page_info", mapList);
            }
        }
        //排序
        if (CollectionUtils.isNotEmpty(sortInfo)) {
            List<Map> newSortInfo = new ArrayList<>();
            for (Map item : sortInfo) {
                if (StringUtils.hasText( item.getOrDefault("schema","").toString())) {
                    //兼容处理
                    if (item.get("orderType") != null
                            && item.get("orderType").toString().contains("desc")) {
                        item.put("orderType","desc");
                    }else{
                        item.put("orderType","asc");
                    }
                    Map<String, Object> sortItem = new HashMap<>();
                    sortItem.put("sort_field", item.get("schema"));
                    sortItem.put("sort_type", item.get("orderType"));
                    sortItem.put("sort_seq", item.get("order"));
                    sortItem.put("table_path", item.get("table_path"));
                    if (StrUtil.isNotBlank((String) item.get("sortFieldPath"))) {
                        sortItem.put("sort_field_path", item.get("sortFieldPath"));
                    }
                    newSortInfo.add(sortItem);
                }
            }
            paras.put("sort_info", newSortInfo);
        }
        //查询
        if (CollectionUtils.isNotEmpty(searchInfo)) {
            paras.put(Variables.SEARCH_VALUE, "");
            paras.put(Variables.SEARCH_INFO, SearchInfoUtil.mergeSearchInfo((List<Map>) paras.get(Variables.SEARCH_INFO), searchInfo));
        }
        //增加鼎捷云上数据权限所需要的作业CODE
        if(!StringUtils.isEmpty(executeContext.getTmActivityId())) {
            paras.put("activityId", executeContext.getTmActivityId());
        }

        if(this.getExtendedData()!=null){
            if(this.getAction().getExtendedFields()==null){
                this.getAction().setExtendedFields(this.getExtendedData());
            }else{
                this.getAction().getExtendedFields().putAll(this.getExtendedData());
            }
        }
        //41799-【制令上线】制令上线卡打开报空指针 esp查询判断queryData是否为true，如果为false则不查询esp。
        if(this.getAction().getQueryData() != null && !this.getAction().getQueryData()){
            return QueryResult.empty(this.getName());
        }
        //查询数据
        HashMap<String, Object> data = SpringUtil.getBean(CommonESPService.class).query(executeContext, this.getAction(), parameter);
        if (data == null || data.size() == 0) {
            QueryResult empty = QueryResult.empty(this.getName());
            empty.setReturnRequestData(paramMap);
            return empty;
        } else {
            QueryResult queryResult = QueryResult.withData(this.getName(), data, pageInfo);
            Object hasNext = data.get("has_next");
            Object totalResults = data.get("total_results");
            if (hasNext instanceof Boolean) {
                queryResult.setHasNext((Boolean) hasNext);
            }
            // total_results支持数字和字符串（包含整数和小数）
            if (totalResults instanceof Number) {
                queryResult.setTotalResults(NumberUtil.toBigDecimal((Number) totalResults).intValue());
            } else if (totalResults instanceof String) {
                queryResult.setTotalResults(NumberUtil.toBigDecimal((String) totalResults).intValue());
            }
            // api返回的分页信息
            Object returnPageInfo = data.get("return_page_info");

            if (returnPageInfo instanceof Collection) {
                queryResult.setReturnPageInfo((Collection<Map<String, Object>>) returnPageInfo);
            }
            // api 返回的合计信息
            Object returnSummaryFields = data.get("return_summary_fields");

            if (returnSummaryFields instanceof Map) {
                queryResult.setReturnSummaryFields((Map<String, Object>) returnSummaryFields);
            }
            queryResult.setReturnRequestData(paramMap);
            Object o = data.get("desensitizationFields");
            if(o instanceof List<?>){
                List<?> list = (List<?>) o;
                List<DesensitizationFieldsRes> desensitizationFields = Lists.newArrayListWithExpectedSize(list.size());
                for (Object element : list) {
                    if (element instanceof Map) {
                        Map<String,Object> row = (Map<String, Object>) element;
                        DesensitizationFieldsRes res = new DesensitizationFieldsRes();
                        res.setConfidentialType(MapUtils.getString(row,"confidentialType"));
                        res.setFieldCode(MapUtils.getString(row,"fieldCode"));
                        desensitizationFields.add(res);
                    }
                }
                queryResult.setDesensitizationFields(desensitizationFields);
            }
            return queryResult;
        }
    }

    /**
     * 附加数据的元数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @return
     */
    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter , QueryResult queryResult) {
        //查询元数据
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        ApiMetadata apiMetadata = SpringUtil.getBean(CommonMetadataService.class).getMetadata(executeContext.getLocale(), this.getAction().getActionId());
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        EspDataSource espDataSource = new EspDataSource();
        espDataSource.setName(this.getName());
        espDataSource.setAction(this.getAction());
        espDataSource.setType(this.getType());
        espDataSource.setDataKeys(this.getDataKeys());
        espDataSource.setActionId(this.getActionId());
        return espDataSource;
    }

}
