package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.ptm.sdk.manager.PtmManager;
import com.digiwin.athena.ptm.sdk.meta.dto.PtmResultDTO;
import com.digiwin.athena.ptm.sdk.meta.dto.response.WorkitemCompletedRespDTO;
import com.jugg.agile.framework.core.util.reflect.bean.copy.JaBeanCopy;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ptm 数据源
 *
 * @author gengwei
 * @since 2024/12/19 09:43
 */
@Data
public class PtmDataSource extends DataSourceBase {

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        String actionId = this.getAction().getActionId();
        if ("athena.ptm.decision.check".equals(actionId)) {
            Map<String, Object> paras = this.getAction().getParas();
            Object workItemId = paras.get("workItemId");
            String s = String.valueOf(workItemId) ;
            PtmResultDTO<WorkitemCompletedRespDTO> decisionBacklogCompleted = PtmManager.getDecisionBacklogCompleted(Long.valueOf(s));
            if (decisionBacklogCompleted.success()) {
                WorkitemCompletedRespDTO data = decisionBacklogCompleted.data();
                if (data != null) {
                    Boolean isClosed = data.getStatus();
                    Map<String, Object> map = new HashMap<>();
                    map.put("backlog_is_completed", isClosed);
                    if (!Boolean.TRUE.equals(isClosed)) {
                        return QueryResult.withSingleData(getName(), map);
                    } else {
                        return QueryResult.empty();
                    }
                }
            }
        }
        return QueryResult.empty();
    }

    @Override
    protected void processParameter(Map<String, Object> parameter, ExecuteContext executeContext) {

    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        return null;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        PtmDataSource ptmDataSource = new PtmDataSource();
        JaBeanCopy.cp(this, ptmDataSource);
        return ptmDataSource;
    }
}
