package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.*;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 自动生成
 * @author: wangminga
 * @create: 2020-08-20 14:31
 **/
@Service("countItemService")
public class CountItemsServiceSource implements DataSourceProcessService {

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 对元数据处理
     *
     * @param dataSourceBase      查询的结果的数据
     * @param executeContext      执行上下文
     * @param dataSourceProcessor 处理器
     * @param queryResult         查询结果
     */
    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        addCountItemsFiled(queryResult.getApiMetadataCollection(), executeContext.getPageCode());
    }

    /**
     * 对数据处理
     *
     * @param dataSourceBase
     * @param executeContext
     * @param dataSourceProcessor 处理器
     * @param queryResult
     */
    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (dataSourceProcessor.getParas() != null) {
            Map<String, List<CountItemData>> paras = JsonUtils.jsonToObject(JsonUtils.objectToString(dataSourceProcessor.getParas()), new TypeReference<Map<String, List<CountItemData>>>() {
            });
            List<CountItemData> countItems = paras.get("countItems");
            addCountItemsData(countItems, queryResult.getData());
        }
    }


    /**
     * 添加COUNT-ITEM 数据
     *
     * @param countItems
     * @param apiData
     */
    private void addCountItemsData(List<CountItemData> countItems, List<Map<String, Object>> apiData) {
        if (CollectionUtils.isEmpty(apiData)) {
            return;
        }
        for (Map<String, Object> datum : apiData) {
            List<Map<String, Object>> checkDataList = new ArrayList<>();
            for (CountItemData countItemData : countItems) {
                Map<String, Object> checkData = new HashMap<>();
                if (!datum.containsKey(countItemData.getKey())) {
                    continue;
                }
                checkData.put("key", countItemData.getKey());
                checkData.put("name", countItemData.getName());
                checkData.put("value", countItemData.getValue());
                checkDataList.add(checkData);
            }
            datum.put("count_result", checkDataList);
        }
    }

    /**
     * 添加COUNT-ITEM 字段
     *
     * @param apiMetadataCollection
     */
    private void addCountItemsFiled(ApiMetadataCollection apiMetadataCollection, String pageCode) {
        //在主数据的metadata上增加一个字段
        if(apiMetadataCollection == null){
            return;
        }
        MetadataField metadataField = new MetadataField();
        metadataField.setArray(true);
        metadataField.setUiBot("Y");
        metadataField.setName("count_result");
        if (ActivityConstants.TASK_DETAIL.equals(pageCode) || ActivityConstants.PROJECT_DETAIL.equals(pageCode)) {
            metadataField.setTagDefinitions(CustomizeTagUtils.createOrderTagDefinitions("999"));
        }
        metadataField.setDescription(messageUtils.getMessage("uibot.acitivity.count.check.title"));
        metadataField.setDataType("object");
        List<MetadataField> subFields = new ArrayList<>();
        MetadataField keyMetadataField = new MetadataField();
        keyMetadataField.setArray(false);
        keyMetadataField.setUiBot("Y");
        keyMetadataField.setName("key");
        keyMetadataField.setDataType("string");
        subFields.add(keyMetadataField);
        MetadataField valueMetadataField = new MetadataField();
        valueMetadataField.setArray(false);
        valueMetadataField.setUiBot("Y");
        valueMetadataField.setName("value");
        valueMetadataField.setDataType("string");
        subFields.add(valueMetadataField);
        MetadataField nameMetadataField = new MetadataField();
        nameMetadataField.setArray(false);
        nameMetadataField.setUiBot("Y");
        nameMetadataField.setName("name");
        nameMetadataField.setDataType("string");
        subFields.add(nameMetadataField);
        metadataField.setSubFields(subFields);
        //todo：暂时放在第一个字段上
        apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).getSubFields().add(metadataField);
    }


}
