/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

final class ParallelQueryTaskUtils {
    private static Logger logger = LoggerFactory.getLogger(ParallelQueryTaskUtils.class);

    private ParallelQueryTaskUtils() {
    }

    public static List<QueryResult> query(ExecuteContext executeContext, Map<String, Object> parameter, List<DataSourceBase> dataSourceList, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) throws ExecutionException, InterruptedException, TimeoutException {
        ArrayList<QueryResult> queryResults = new ArrayList<QueryResult>();
        ExecutorService executorService = (ExecutorService)SpringUtil.getBean((String)"asyncServiceExecutor");
        ArrayList<CompletableFuture<QueryResult>> futures = new ArrayList<CompletableFuture<QueryResult>>();
        for (DataSourceBase dataSourceBase : dataSourceList) {
            QueryTask queryTask = new QueryTask(executeContext, parameter, dataSourceBase, pageInfo, sortInfo, searchInfo);
            CompletableFuture<QueryResult> future = CompletableFuture.supplyAsync(queryTask, executorService);
            futures.add(future);
        }
        for (CompletableFuture completableFuture : futures) {
            QueryResult result = (QueryResult)completableFuture.get(70L, TimeUnit.SECONDS);
            if (result == null) continue;
            queryResults.add(result);
        }
        return queryResults;
    }

    public static List<QueryResult> queryWithMetaData(ExecuteContext executeContext, Map<String, Object> parameter, List<DataSourceBase> dataSourceList, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) throws ExecutionException, InterruptedException, TimeoutException {
        ArrayList<QueryResult> queryResults = new ArrayList<QueryResult>();
        ExecutorService executorService = (ExecutorService)SpringUtil.getBean((String)"asyncServiceExecutor");
        ArrayList<CompletableFuture<QueryResult>> futures = new ArrayList<CompletableFuture<QueryResult>>();
        Long start = System.currentTimeMillis();
        for (DataSourceBase dataSourceBase : dataSourceList) {
            QueryWithMetaDataTask queryTask = new QueryWithMetaDataTask(executeContext, parameter, dataSourceBase, pageInfo, sortInfo, searchInfo);
            CompletableFuture<QueryResult> future = CompletableFuture.supplyAsync(queryTask, executorService);
            futures.add(future);
        }
        for (CompletableFuture completableFuture : futures) {
            QueryResult result = (QueryResult)completableFuture.get(70L, TimeUnit.SECONDS);
            if (result == null) continue;
            queryResults.add(result);
        }
        logger.info("\u591a\u7ebf\u7a0b\u603b\u6570" + dataSourceList.size() + "\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return queryResults;
    }

    static class QueryWithMetaDataTask
    implements Supplier<QueryResult> {
        private final ExecuteContext executeContext;
        private final Map<String, Object> parameter;
        private final DataSourceBase dataSourceBase;
        private final Locale locale;
        private final AppAuthContext appAuthContext;
        private final PageInfo pageInfo;
        private final List<Map> sortInfo;
        private final List<Map> searchInfo;

        public QueryWithMetaDataTask(ExecuteContext executeContext, Map<String, Object> parameter, DataSourceBase dataSourceBase, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
            this.executeContext = executeContext;
            this.parameter = parameter;
            this.pageInfo = pageInfo;
            this.sortInfo = sortInfo;
            this.searchInfo = searchInfo;
            this.dataSourceBase = dataSourceBase;
            this.appAuthContext = AppAuthContextHolder.getContext();
            this.locale = LocaleContextHolder.getLocale();
        }

        @Override
        public QueryResult get() {
            LocaleContextHolder.setLocale((Locale)this.locale);
            AppAuthContextHolder.setContext((AppAuthContext)this.appAuthContext);
            logger.info("\u591a\u7ebf\u7a0b" + Thread.currentThread().getName());
            Long start = System.currentTimeMillis();
            QueryResult queryResult = this.dataSourceBase.queryWithMetaData(this.executeContext, this.parameter, this.pageInfo, this.sortInfo, this.searchInfo);
            logger.info("\u591a\u7ebf\u7a0b" + Thread.currentThread().getName() + "\u8017\u65f6:" + (System.currentTimeMillis() - start));
            return queryResult;
        }
    }

    static class QueryTask
    implements Supplier<QueryResult> {
        private final ExecuteContext executeContext;
        private final Map<String, Object> parameter;
        private final DataSourceBase dataSourceBase;
        private final Locale locale;
        private final AppAuthContext appAuthContext;
        private final PageInfo pageInfo;
        private final List<Map> sortInfo;
        private final List<Map> searchInfo;

        public QueryTask(ExecuteContext executeContext, Map<String, Object> parameter, DataSourceBase dataSourceBase, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
            this.executeContext = executeContext;
            this.parameter = parameter;
            this.pageInfo = pageInfo;
            this.sortInfo = sortInfo;
            this.searchInfo = searchInfo;
            this.dataSourceBase = dataSourceBase;
            this.appAuthContext = AppAuthContextHolder.getContext();
            this.locale = LocaleContextHolder.getLocale();
        }

        @Override
        public QueryResult get() {
            LocaleContextHolder.setLocale((Locale)this.locale);
            AppAuthContextHolder.setContext((AppAuthContext)this.appAuthContext);
            Long start = System.currentTimeMillis();
            QueryResult queryResult = this.dataSourceBase.query(this.executeContext, this.parameter, this.pageInfo, this.sortInfo, this.searchInfo);
            logger.info("\u591a\u7ebf\u7a0b" + Thread.currentThread().getName() + "\u8017\u65f6:" + (System.currentTimeMillis() - start));
            return queryResult;
        }
    }
}

