package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

final class  ParallelQueryTaskUtils  {
    private static Logger logger = LoggerFactory.getLogger(ParallelQueryTaskUtils.class);

    private ParallelQueryTaskUtils(){}

    public static  List<QueryResult>  query(ExecuteContext executeContext, Map<String, Object> parameter, List<DataSourceBase> dataSourceList, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo ) throws ExecutionException, InterruptedException, TimeoutException {
        List<QueryResult> queryResults = new ArrayList<>();
        ExecutorService executorService = (ExecutorService)SpringUtil.getBean("asyncServiceExecutor");
        List<CompletableFuture<QueryResult>> futures = new ArrayList<>();
        for (DataSourceBase dataSourceBase : dataSourceList) {
            QueryTask queryTask = new QueryTask(executeContext,parameter,dataSourceBase,pageInfo,sortInfo,searchInfo);
            CompletableFuture<QueryResult> future = CompletableFuture.supplyAsync(queryTask, executorService);
            futures.add(future);
        }

        for (CompletableFuture<QueryResult> future : futures) {
            QueryResult result =  future.get(70,TimeUnit.SECONDS);
            if (result != null) {
                queryResults.add(result);
            }
        }
        return queryResults;
    }

    public static  List<QueryResult>  queryWithMetaData(ExecuteContext executeContext,Map<String, Object> parameter, List<DataSourceBase> dataSourceList, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo ) throws ExecutionException, InterruptedException, TimeoutException {
        List<QueryResult> queryResults = new ArrayList<>();
        ExecutorService executorService = (ExecutorService) SpringUtil.getBean("asyncServiceExecutor");
        List<CompletableFuture<QueryResult>> futures = new ArrayList<>();
        Long start =  System.currentTimeMillis();
        AppAuthContext appAuthContext = AppAuthContextHolder.getContext();
        Locale locale = LocaleContextHolder.getLocale();
        for (DataSourceBase dataSourceBase : dataSourceList) {
            // QueryWithMetaDataTask queryTask = new QueryWithMetaDataTask(executeContext, parameter, dataSourceBase,pageInfo,sortInfo,searchInfo);
            CompletableFuture<QueryResult> future = CompletableFuture.supplyAsync(()->{
                QueryResult queryResult;
                try {
                    org.springframework.context.i18n.LocaleContextHolder.setLocale(locale);
                    AppAuthContextHolder.setContext(appAuthContext);
                    logger.info("多线程" + Thread.currentThread().getName());
                    Long start1 = System.currentTimeMillis();
                    queryResult = dataSourceBase.queryWithMetaData(executeContext, parameter, pageInfo, sortInfo, searchInfo);
                    logger.info("多线程" + Thread.currentThread().getName() + "耗时:" + (System.currentTimeMillis() - start1));
                } finally {
                }
                return queryResult;
            }, executorService);
            futures.add(future);
        }
        for (CompletableFuture<QueryResult> future : futures) {
            QueryResult result =  future.get(70,TimeUnit.SECONDS);
            if (result != null) {
                queryResults.add(result);
            }
        }
        logger.info("多线程总数"+dataSourceList.size()+"耗时："+(System.currentTimeMillis() - start));
        return queryResults;
    }

    static class QueryTask implements Supplier<QueryResult> {
        final private ExecuteContext executeContext;
        final private Map<String, Object> parameter;
        final private DataSourceBase dataSourceBase;
        final private Locale locale;
        final private AppAuthContext appAuthContext;
        final private PageInfo pageInfo;
        final private List<Map> sortInfo;
        final private List<Map> searchInfo;
        public QueryTask(ExecuteContext executeContext, Map<String, Object> parameter, DataSourceBase dataSourceBase, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo ) {
            this.executeContext = executeContext;
            this.parameter = parameter;
            this.pageInfo = pageInfo;
            this.sortInfo = sortInfo;
            this.searchInfo = searchInfo;
            this.dataSourceBase = dataSourceBase;
            this.appAuthContext = AppAuthContextHolder.getContext();

            this.locale =  org.springframework.context.i18n.LocaleContextHolder.getLocale();
        }

        /**
         * Gets a result.
         *
         * @return a result
         */
        @Override
        public QueryResult get() {
            org.springframework.context.i18n.LocaleContextHolder.setLocale(locale);
            AppAuthContextHolder.setContext(this.appAuthContext);
            Long start =  System.currentTimeMillis();
            QueryResult queryResult = dataSourceBase.query(executeContext,parameter,pageInfo,sortInfo,searchInfo);
            logger.info("多线程"+Thread.currentThread().getName()+"耗时:"+(System.currentTimeMillis() - start));
            return queryResult;
        }
    }
    static class QueryWithMetaDataTask implements Supplier<QueryResult> {
        final private ExecuteContext executeContext;
        final private Map<String, Object> parameter;
        final private DataSourceBase dataSourceBase;
        final private Locale locale;
        final private AppAuthContext appAuthContext;
        final private PageInfo pageInfo;
        final private List<Map> sortInfo;
        final private List<Map> searchInfo;
        public QueryWithMetaDataTask(ExecuteContext executeContext,  Map<String, Object> parameter, DataSourceBase dataSourceBase, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo  ) {
            this.executeContext = executeContext;
            this.parameter = parameter;
            this.pageInfo = pageInfo;
            this.sortInfo = sortInfo;
            this.searchInfo = searchInfo;
            this.dataSourceBase = dataSourceBase;
            this.appAuthContext = AppAuthContextHolder.getContext();
            this.locale =  org.springframework.context.i18n.LocaleContextHolder.getLocale();
        }

        public QueryResult get() {
            QueryResult queryResult;
            try {
                org.springframework.context.i18n.LocaleContextHolder.setLocale(locale);
                AppAuthContextHolder.setContext(this.appAuthContext);
                logger.info("多线程" + Thread.currentThread().getName());
                Long start = System.currentTimeMillis();
                queryResult = dataSourceBase.queryWithMetaData(executeContext, parameter, pageInfo, sortInfo, searchInfo);
                logger.info("多线程" + Thread.currentThread().getName() + "耗时:" + (System.currentTimeMillis() - start));
            } finally {
            }

            return queryResult;

        }
    }
}