package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import com.digiwin.athena.atdm.uibot.dto.UserDefinedCenterMetadataResult;
import com.digiwin.athena.atdm.audc.CommonAudcService;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.TagConstant;
import com.digiwin.athena.atdm.datasource.domain.TagDefinition;
import com.digiwin.athena.atdm.datasource.domain.ThemeMapTag;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * RecycleDataSource Description
 *
 * @author majianfu
 * @date 2021/5/17
 * @since
 */
@Data
public class RecycleDataSource extends DataSourceBase {


    public RecycleDataSource() {
        super();
        this.setType(UiBotConstants.ACTION_CATEGORY_RECYCLE);
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo) {
        // 从回收站查询业务数据
        if (this.getAction() == null) {
            return QueryResult.empty(this.getName());
        }

        List dataList = SpringUtil.getBean(CommonRecycleService.class).queryActivityDataList(executeContext.getAuthoredUser().getTenantId(), executeContext.getTmActivityId());
        if (CollectionUtils.isNotEmpty(dataList)) {
            return QueryResult.withData(this.getName(), dataList);
        } else {
            return QueryResult.empty(this.getName());
        }
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext,  Map<String, Object> parameter, QueryResult queryResult) {
        // 从ESP查询元数据
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        ApiMetadata apiMetadata = SpringUtil.getBean(CommonMetadataService.class).getMetadata(executeContext.getLocale(), this.getAction().getActionId());
        appendCustomFields(executeContext,apiMetadata);
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }

    private void appendCustomFields(ExecuteContext executeContext,ApiMetadata apiMetadata) {
        if (null == apiMetadata || CollectionUtils.isEmpty(apiMetadata.getResponseFields())) {
            return;
        }

        MetadataField topField =apiMetadata.getResponseFields().get(0);
        if(CollectionUtils.isEmpty(topField.getSubFields())) {
            return;
        }

        MessageUtils messageUtils = SpringUtil.getBean(MessageUtils.class);

        List<MetadataField> allRespFields = new LinkedList<>();

        // 将新增的两列放在最前面
        List<UserDefinedCenterMetadataResult> metadataMetadataTagResults = Lists.newArrayList();
        Map<String, Object> paramMap = new LinkedHashMap<>();
        paramMap.put("pageCode", executeContext.getPageCode());
        if (StringUtils.isNotEmpty(executeContext.getTmProjectId())) {
            paramMap.put("tmProjectId", executeContext.getTmProjectId());
        } else {
            paramMap.put("tmProjectId", "__uibot__");
        }
        if (StringUtils.isNotEmpty(executeContext.getTmActivityId())) {
            paramMap.put("tmActivityId", executeContext.getTmActivityId());
            metadataMetadataTagResults = SpringUtil.getBean(CommonAudcService.class).getFieldsSeqByUser(paramMap, executeContext);
        }
        if(CollectionUtils.isNotEmpty(topField.getSubFields())) {
            Optional<MetadataField> userNameFieldOpt = topField.getSubFields().stream().filter(field -> StringUtils.equals("uibot__userName",field.getName())).findFirst();
            Optional<MetadataField> userDateTimeFieldOpt = topField.getSubFields().stream().filter(field -> StringUtils.equals("uibot__dateTime",field.getName())).findFirst();

            if(userNameFieldOpt.isPresent()){
                MetadataField userNameMetadataField = userNameFieldOpt.get();
                userNameMetadataField.setTagDefinitions(createTagDefs(userNameMetadataField,executeContext,metadataMetadataTagResults));
            } else {
                allRespFields.add(createCustomField("uibot__userName", messageUtils.getMessage("recycle_uibot__userName"), executeContext, metadataMetadataTagResults));
            }
            if(userDateTimeFieldOpt.isPresent()){
                MetadataField userDateTimeMetadataField = userDateTimeFieldOpt.get();
                userDateTimeMetadataField.setTagDefinitions(createTagDefs(userDateTimeMetadataField,executeContext,metadataMetadataTagResults));
            } else {
                allRespFields.add(createCustomField("uibot__dateTime", messageUtils.getMessage("recycle_uibot__dateTime"), executeContext, metadataMetadataTagResults));
            }
        }
        allRespFields.addAll(topField.getSubFields());
        topField.setSubFields(allRespFields);
    }

    private MetadataField createCustomField(String name, String description,ExecuteContext executeContext,List<UserDefinedCenterMetadataResult> metadataMetadataTagResults) {
        MetadataField field = new MetadataField();
        field.setName(name);
        field.setDescription(description);
        field.setDataKey("false");
        field.setDataType("string");

        field.setTagDefinitions(createTagDefs(field,executeContext,metadataMetadataTagResults));

        return field;
    }

    private List<TagDefinition> createTagDefs(MetadataField field,ExecuteContext executeContext,List<UserDefinedCenterMetadataResult> metadataMetadataTagResults){
        List<TagDefinition> tagDefs = new ArrayList<>();
        TagDefinition typeStringTagDef = CustomizeTagUtils.createDataTypeDefinition(field);
        tagDefs.add(typeStringTagDef);


        TagDefinition orderTagDef = this.getOrderTag(field,executeContext,metadataMetadataTagResults);

        tagDefs.add(orderTagDef);

        ThemeMapTag themeMapTag = new ThemeMapTag();
        themeMapTag.setName("xxx");
        themeMapTag.setCategory(TagConstant.ORDER_TAG);
        themeMapTag.setValue(orderTagDef.getTmTagValue());
        themeMapTag.setCode(TagConstant.ORDER_PREFIX + orderTagDef.getTmTagValue());
        themeMapTag.setUiBotCode(TagConstant.ORDER_TAG);
        typeStringTagDef.setThemeMapTag(themeMapTag);
        orderTagDef.setThemeMapTag(themeMapTag);
        return tagDefs;
    }

    private TagDefinition getOrderTag(MetadataField field,ExecuteContext executeContext,List<UserDefinedCenterMetadataResult> metadataMetadataTagResults){
        TagDefinition orderTagDef;
        String orderValue = "10";
        //获取自定义排序
        if(CollectionUtils.isNotEmpty(metadataMetadataTagResults)){
            for(UserDefinedCenterMetadataResult userTag : metadataMetadataTagResults){
                if(userTag.getResourceContent().getResponse().contains(field.getName())){
                    for (ThemeMapTag tag : userTag.getTags()) {
                        if (tag.getCode().contains("ORDER")) {
                            orderValue = tag.getValue();
                            break;
                        }
                    }
                }
            }
        }
        orderTagDef = CustomizeTagUtils.createOrderTagDefinitions(orderValue).get(0);
        return orderTagDef;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        RecycleDataSource dataSource = new RecycleDataSource();
        dataSource.setName(this.getName());
        dataSource.setAction(this.getAction());
        dataSource.setType(this.getType());
        dataSource.setDataKeys(this.getDataKeys());
        dataSource.setActionId(this.getActionId());
        return dataSource;
    }
}
