package com.digiwin.athena.atdm.datasource.datasource.process;


import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.TagConstant;
import com.digiwin.athena.atdm.datasource.domain.TagDefinition;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * @description: 创建自定义标签
 * @author: wangminga
 * @create: 2020-10-12 16:11
 **/
public class CustomizeTagUtils {

    private static final String DATA_TYPE_DATE = "date";

    private static final String DATA_TYPE_STRING = "string";

    private static final String DATA_TYPE_NUMBER = "number";

    private static final String DATA_TYPE_NUMERIC = "numeric";

    private static final String DATA_TYPE_BOOLEAN = "boolean";

    public static TagDefinition  createTagDefinition() {
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCode(UUID.randomUUID().toString());
        tagDefinition.setName("随机标签");
        tagDefinition.setCustomize(true);
        return tagDefinition;
    }


    public static  List<TagDefinition> createTagDefinitions() {
        List<TagDefinition> tagDefinitions = new ArrayList<>();
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCode(UUID.randomUUID().toString());
        tagDefinition.setName("随机标签");
        tagDefinition.setCustomize(true);
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }


    public static List<TagDefinition> createOrderTagDefinitions(String value) {
        List<TagDefinition> tagDefinitions = new ArrayList<>();
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setTmTagCode(TagConstant.ORDER_PREFIX + value);
        tagDefinition.setTmTagValue(value);
        tagDefinition.setCode(TagConstant.ORDER_TAG);
        tagDefinition.setName("顺序标签");
        tagDefinition.setDescription("排序使用");
        tagDefinition.setCategory("ORDER");
        tagDefinition.setInterpreterServiceName("");
        tagDefinition.setCustomize(false);
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }


    public static List<TagDefinition> createTemplateMiddleTagDefinitions() {
        List<TagDefinition> tagDefinitions = new ArrayList<>();
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setTmTagCode(TagConstant.CHARGE_APPROVAL_TEMPLATE_MIDDLE);
        tagDefinition.setCode(TagConstant.CHARGE_APPROVAL_TEMPLATE_MIDDLE);
        tagDefinition.setName("是否重要属性");
        tagDefinition.setDescription("是否重要属性");
        tagDefinition.setCategory(TagConstant.CATEGORY_BUSINESS);
//        tagDefinition.setInterpreterServiceName("importantTagInterpreter");
        tagDefinition.setCustomize(false);

        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }


    /**
     * 创建数据标签
     *
     * @param metadataField
     * @return
     */
    public List<TagDefinition> createDataTypeTagDefinitions(MetadataField metadataField) {
        List<TagDefinition> tagDefinitions = new ArrayList<>();
        tagDefinitions.add(createDataTypeDefinition(metadataField));
        return tagDefinitions;
    }

    /**
     * 创建数据标签
     *
     * @param metadataField
     * @return
     */
    public static void createDataTypeTagDefinition(MetadataField metadataField) {
        List<TagDefinition> tagDefinitions = metadataField.getTagDefinitions();
        if (CollectionUtils.isEmpty(tagDefinitions)) {
            tagDefinitions = new ArrayList<>();
            tagDefinitions.add(createDataTypeDefinition(metadataField));
        }else{
            boolean addFlag = true;
            for (TagDefinition tagDefinition : tagDefinitions) {
                if(StringUtils.isNotBlank(tagDefinition.getInterpreterServiceName())){
                    addFlag =false;
                }
            }
            if(addFlag){
                tagDefinitions.add(createDataTypeDefinition(metadataField));
            }

        }
        metadataField.setTagDefinitions(tagDefinitions);
    }


    public static TagDefinition createDataTypeDefinition(MetadataField metadataField) {
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setName("数据组件");
        tagDefinition.setDescription("数据组件");
        tagDefinition.setCategory(TagConstant.CATEGORY_DATATYPE);
        tagDefinition.setCustomize(false);
        if (DATA_TYPE_DATE.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode(TagConstant.TYPE_DATE_TAG);
            tagDefinition.setCode(TagConstant.TYPE_DATE_TAG);
            tagDefinition.setInterpreterServiceName("typeDateTagInterpreter");
        } else if (DATA_TYPE_STRING.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode(TagConstant.TYPE_STRING_TAG);
            tagDefinition.setCode(TagConstant.TYPE_STRING_TAG);

            if ("uibot__operationReason".equals(metadataField.getName())) {
                tagDefinition.setInterpreterServiceName("textAreaTagInterpreter");
            }else {
                tagDefinition.setInterpreterServiceName("typeStringTagInterpreter");
            }

        } else if (DATA_TYPE_NUMBER.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode(TagConstant.TYPE_NUMBER_TAG);
            tagDefinition.setCode(TagConstant.TYPE_NUMBER_TAG);
            tagDefinition.setInterpreterServiceName("typeNumberTagInterpreter");
        } else if (DATA_TYPE_BOOLEAN.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode(TagConstant.TYPE_BOOLEAN_TAG);
            tagDefinition.setCode(TagConstant.TYPE_BOOLEAN_TAG);
            tagDefinition.setInterpreterServiceName("typeBooleanTagInterpreter");
        } else if (DATA_TYPE_NUMERIC.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode(TagConstant.TYPE_NUMERIC_TAG);
            tagDefinition.setCode(TagConstant.TYPE_NUMERIC_TAG);
            tagDefinition.setInterpreterServiceName("typeNumericTagInterpreter");
        }
        return tagDefinition;
    }

    /**
     * 构建附件tag
     *
     * @return 附件tag列表
     */
    public static List<TagDefinition> buildAttachmentFileTagDefs(String tagName, String tagDescription) {
        List<TagDefinition> tagDefinitions = Lists.newArrayList();

        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCode(TagConstant.BUSINESS_ATTACHMENT_FILE);
        tagDefinition.setName(tagName);
        tagDefinition.setDescription(tagDescription);
        tagDefinition.setCategory(TagConstant.CATEGORY_BUSINESS);
        tagDefinition.setInterpreterServiceName("attachmentFileInterpreter");
        tagDefinition.setCustomize(false);

        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }
}
