/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.audc.CommonAudcService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.TagDefinition;
import com.digiwin.athena.atdm.datasource.domain.ThemeMapTag;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.uibot.dto.UserDefinedCenterMetadataResult;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RecycleDataSource
extends DataSourceBase {
    public RecycleDataSource() {
        this.setType("RECYCLE");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (this.getAction() == null) {
            return QueryResult.empty((String)this.getName());
        }
        List dataList = ((CommonRecycleService)SpringUtil.getBean(CommonRecycleService.class)).queryActivityDataList(executeContext.getAuthoredUser().getTenantId(), executeContext.getTmActivityId());
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            return QueryResult.withData((String)this.getName(), (List)dataList);
        }
        return QueryResult.empty((String)this.getName());
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        ApiMetadata apiMetadata = ((CommonMetadataService)SpringUtil.getBean(CommonMetadataService.class)).getMetadata(executeContext.getLocale(), this.getAction().getActionId());
        this.appendCustomFields(executeContext, apiMetadata);
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }

    private void appendCustomFields(ExecuteContext executeContext, ApiMetadata apiMetadata) {
        if (null == apiMetadata || CollectionUtils.isEmpty((Collection)apiMetadata.getResponseFields())) {
            return;
        }
        MetadataField topField = (MetadataField)apiMetadata.getResponseFields().get(0);
        if (CollectionUtils.isEmpty((Collection)topField.getSubFields())) {
            return;
        }
        MessageUtils messageUtils = (MessageUtils)SpringUtil.getBean(MessageUtils.class);
        LinkedList<MetadataField> allRespFields = new LinkedList<MetadataField>();
        List metadataMetadataTagResults = Lists.newArrayList();
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("pageCode", executeContext.getPageCode());
        if (StringUtils.isNotEmpty((String)executeContext.getTmProjectId())) {
            paramMap.put("tmProjectId", executeContext.getTmProjectId());
        } else {
            paramMap.put("tmProjectId", "__uibot__");
        }
        if (StringUtils.isNotEmpty((String)executeContext.getTmActivityId())) {
            paramMap.put("tmActivityId", executeContext.getTmActivityId());
            metadataMetadataTagResults = ((CommonAudcService)SpringUtil.getBean(CommonAudcService.class)).getFieldsSeqByUser(paramMap, executeContext);
        }
        if (CollectionUtils.isNotEmpty((Collection)topField.getSubFields())) {
            Optional<MetadataField> userNameFieldOpt = topField.getSubFields().stream().filter(field -> StringUtils.equals((String)"uibot__userName", (String)field.getName())).findFirst();
            Optional<MetadataField> userDateTimeFieldOpt = topField.getSubFields().stream().filter(field -> StringUtils.equals((String)"uibot__dateTime", (String)field.getName())).findFirst();
            if (userNameFieldOpt.isPresent()) {
                MetadataField userNameMetadataField = userNameFieldOpt.get();
                userNameMetadataField.setTagDefinitions(this.createTagDefs(userNameMetadataField, executeContext, metadataMetadataTagResults));
            } else {
                allRespFields.add(this.createCustomField("uibot__userName", messageUtils.getMessage("recycle_uibot__userName"), executeContext, metadataMetadataTagResults));
            }
            if (userDateTimeFieldOpt.isPresent()) {
                MetadataField userDateTimeMetadataField = userDateTimeFieldOpt.get();
                userDateTimeMetadataField.setTagDefinitions(this.createTagDefs(userDateTimeMetadataField, executeContext, metadataMetadataTagResults));
            } else {
                allRespFields.add(this.createCustomField("uibot__dateTime", messageUtils.getMessage("recycle_uibot__dateTime"), executeContext, metadataMetadataTagResults));
            }
        }
        allRespFields.addAll(topField.getSubFields());
        topField.setSubFields(allRespFields);
    }

    private MetadataField createCustomField(String name, String description, ExecuteContext executeContext, List<UserDefinedCenterMetadataResult> metadataMetadataTagResults) {
        MetadataField field = new MetadataField();
        field.setName(name);
        field.setDescription(description);
        field.setDataKey("false");
        field.setDataType("string");
        field.setTagDefinitions(this.createTagDefs(field, executeContext, metadataMetadataTagResults));
        return field;
    }

    private List<TagDefinition> createTagDefs(MetadataField field, ExecuteContext executeContext, List<UserDefinedCenterMetadataResult> metadataMetadataTagResults) {
        ArrayList<TagDefinition> tagDefs = new ArrayList<TagDefinition>();
        TagDefinition typeStringTagDef = CustomizeTagUtils.createDataTypeDefinition(field);
        tagDefs.add(typeStringTagDef);
        TagDefinition orderTagDef = this.getOrderTag(field, executeContext, metadataMetadataTagResults);
        tagDefs.add(orderTagDef);
        ThemeMapTag themeMapTag = new ThemeMapTag();
        themeMapTag.setName("xxx");
        themeMapTag.setCategory("ORDER");
        themeMapTag.setValue(orderTagDef.getTmTagValue());
        themeMapTag.setCode("ORDER_" + orderTagDef.getTmTagValue());
        themeMapTag.setUiBotCode("ORDER");
        typeStringTagDef.setThemeMapTag(themeMapTag);
        orderTagDef.setThemeMapTag(themeMapTag);
        return tagDefs;
    }

    private TagDefinition getOrderTag(MetadataField field, ExecuteContext executeContext, List<UserDefinedCenterMetadataResult> metadataMetadataTagResults) {
        String orderValue = "10";
        if (CollectionUtils.isNotEmpty(metadataMetadataTagResults)) {
            block0: for (UserDefinedCenterMetadataResult userTag : metadataMetadataTagResults) {
                if (!userTag.getResourceContent().getResponse().contains(field.getName())) continue;
                for (ThemeMapTag tag : userTag.getTags()) {
                    if (!tag.getCode().contains("ORDER")) continue;
                    orderValue = tag.getValue();
                    continue block0;
                }
            }
        }
        TagDefinition orderTagDef = CustomizeTagUtils.createOrderTagDefinitions(orderValue).get(0);
        return orderTagDef;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        RecycleDataSource dataSource = new RecycleDataSource();
        dataSource.setName(this.getName());
        dataSource.setAction(this.getAction());
        dataSource.setType(this.getType());
        dataSource.setDataKeys(this.getDataKeys());
        dataSource.setActionId(this.getActionId());
        return dataSource;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecycleDataSource)) {
            return false;
        }
        RecycleDataSource other = (RecycleDataSource)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecycleDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "RecycleDataSource()";
    }
}

