/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.thememap.CommonThemeMapService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class TmDataSource
extends DataSourceBase {
    public TmDataSource() {
        this.setType("TM");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (this.getAction() == null) {
            return QueryResult.empty((String)this.getName());
        }
        if (!StringUtils.hasText((String)this.getAction().getServiceId().getServiceUri())) {
            return QueryResult.empty((String)this.getName());
        }
        HashMap value = ((CommonThemeMapService)SpringUtil.getBean(CommonThemeMapService.class)).postByRelativeUri(this.getAction().getServiceId().getServiceUri(), this.getAction().getParas());
        if (value == null) {
            return QueryResult.empty((String)this.getName());
        }
        AtomicReference<QueryResult> queryResult = new AtomicReference<QueryResult>();
        value.forEach((k, v) -> {
            if (v instanceof Collection) {
                queryResult.set(QueryResult.withData((String)this.getName(), (List)((List)v)));
            } else if (v instanceof Map) {
                queryResult.set(QueryResult.withSingleData((String)this.getName(), (Map)((Map)v)));
            }
        });
        if (queryResult.get() == null) {
            if (value instanceof Collection) {
                queryResult.set(QueryResult.withData((String)this.getName(), (List)((List)((Object)value))));
            } else if (value instanceof Map) {
                ArrayList<HashMap> dataList = new ArrayList<HashMap>();
                dataList.add(value);
                queryResult.set(QueryResult.withData((String)this.getName(), dataList));
            }
        }
        return (QueryResult)queryResult.get();
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        ApiMetadata apiMetadata = ((CommonMetadataService)SpringUtil.getBean(CommonMetadataService.class)).getMetadata(executeContext.getLocale(), this.getAction().getActionId());
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        TmDataSource tmDataSource = new TmDataSource();
        tmDataSource.setName(this.getName());
        tmDataSource.setAction(this.getAction());
        tmDataSource.setType(this.getType());
        tmDataSource.setDataKeys(this.getDataKeys());
        tmDataSource.setActionId(this.getActionId());
        return tmDataSource;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TmDataSource)) {
            return false;
        }
        TmDataSource other = (TmDataSource)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TmDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "TmDataSource()";
    }
}

