package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.atdm.datasource.domain.TaskWithBacklogData;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 母子任务辅助处理类
 */
public class DeriveUtil {

    public static void addSubTaskData(TaskWithBacklogData taskWithBacklogData, Map<String, Object> data) {
        String unikeys =  taskWithBacklogData.getBpmData().get("__DERIVE_TASK_RELATION_UNIKEYS").toString();
        String[] dataKeyList = unikeys.split(";");
        Map task = (HashMap) taskWithBacklogData.getBpmData().get("__DERIVE_TASK_RELATION");
        if (task != null && task.size() > 0) {
            //先找到数据上key对应的值
            String queryItemKeyValue = "";
            for (Object keyItem : dataKeyList) {
                if(data.get(keyItem) != null) {
                    queryItemKeyValue += data.get(keyItem).toString();
                }
            }
            for (Object key : task.keySet()) {
                //如果数据中不存在这个字段，就跳过
                if (!data.containsKey(key)){
                    continue;
                }
                String name ="uibot__" + key + "__subTask";
                List<Map> subTasks=  (List<Map>) task.get(key);
                if (!CollectionUtils.isEmpty(subTasks)) {
                    for (Map subTask : subTasks) {
                        if (!subTask.containsKey("__DERIVE_TASK_BACKLOG_ID") || subTask.get("__DERIVE_TASK_BACKLOG_ID") ==null){
                            //如果不包含子任务信息，跳过
                            continue;
                        }
                        if (!subTask.containsKey("existedItemKeyValue")) {
                            String existedItemKeyValue = "";
                            for (Object keyItem : dataKeyList) {
                                if (subTask.get(keyItem) != null) {
                                    existedItemKeyValue += subTask.get(keyItem).toString();
                                }
                            }
                            if (StringUtils.isEmpty(existedItemKeyValue )){
                                //防止都是空，做一个特殊标记
                                existedItemKeyValue ="NON";
                            }
                            subTask.put("existedItemKeyValue", existedItemKeyValue);
                        }
                        //如果数据行刚好和关联的子任务数据的key对应上
                        if (queryItemKeyValue.equals(subTask.get("existedItemKeyValue"))){
                            Map<String,Object> subTaskInfo = new HashMap<>();
                            subTaskInfo.put("id",subTask.get("__DERIVE_TASK_BACKLOG_ID"));
                            if (subTask.containsKey("__DERIVE_TASK_BACKLOG_CLOSED")
                                    && subTask.get("__DERIVE_TASK_BACKLOG_CLOSED") != null) {
                                subTaskInfo.put("status", (boolean)subTask.get("__DERIVE_TASK_BACKLOG_CLOSED") ? "stop" : "running");
                            }else {
                                subTaskInfo.put("status", "unknown");
                            }
                            data.put(name, subTaskInfo);
                        }
                    }
                }
            }
        }
    }

}
