package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.datasource.BuildPageDataProcessService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.domain.TagConstant;
import com.digiwin.athena.atdm.datasource.domain.TagDefinition;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * AppendButtonGroupService Description
 *
 * @author majianfu
 * @date 2021/4/14
 * @since
 */
@Service(AppendButtonGroupFieldService.ATTACHMENT_DS_SERVICE_INSTANCE_NAME)
public class AppendButtonGroupFieldService implements BuildPageDataProcessService {
    public static final String ATTACHMENT_DS_SERVICE_INSTANCE_NAME = "appendButtonGroupFieldService";

    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void handelPageData(ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResultSet queryResultSet) {
        addButtonGroupField(queryResultSet.getMainQueryResult().getApiMetadataCollection());
    }

    private void addButtonGroupField(ApiMetadataCollection apiMetadataCollection) {
        if (apiMetadataCollection == null) {
            return;
        }

        MetadataField field = new MetadataField();
        field.setUiBot("Y");
        field.setName("BUTTON_GROUP");
        field.setDataType("string");

        field.setDescription(messageUtils.getMessage("uibot.activity.metadataField.operation"));
        field.setTagDefinitions(buildButtonGroupTagDef());

        List<MetadataField> metadataFields = apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).getSubFields();
        metadataFields.add(field);
    }

    /**
     * 构建附件tag
     *
     * @return 附件tag列表
     */
    public static List<TagDefinition> buildButtonGroupTagDef() {
        List<TagDefinition> tagDefs = Lists.newArrayList();

        TagDefinition tagDef = new TagDefinition();
        tagDef.setCode(TagConstant.BUSINESS_BUTTON_GROUP);
        tagDef.setCategory(TagConstant.CATEGORY_BUSINESS);
        tagDef.setInterpreterServiceName("buttonGroupInterpreter");
        tagDef.setCustomize(false);

        tagDefs.add(tagDef);
        return tagDefs;
    }


}
