package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity;

import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author：SYQ
 * @date：2022/5/13
 */
@Service("removeAbnormalDataService")
public class RemoveAbnormalDataService implements DataSourceProcessService {

    @Autowired
    private DataUnfiormityProcessor dataUnfiormityProcessor;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        //无需处理
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        List<Map<String,Object>> dataList = queryResult.getData();
        if(CollectionUtils.isEmpty(dataList) || null == dataSourceProcessor.getParas()){
            return;
        }
        //获取异动数据
        Set<Map<String,Object>> abnormalDataSet = dataUnfiormityProcessor.comparisonData(dataList,dataSourceProcessor);
        //删除异动数据
        List<Map<String,Object>> resultList = new ArrayList<>();

        for (Map<String,Object> dataMap : dataList) {
            if(!abnormalDataSet.contains(dataMap)){
                resultList.add(dataMap);
            }
        }

        int totalKeySize = queryResult.keySize();

        queryResult.setData(resultList);
        queryResult.initializeDataKey();
        queryResult.setAbnormalDataSize(abnormalDataSet.size());
        queryResult.setAbnormalDataKeyIndexSize(totalKeySize - queryResult.keySize());

    }
}
