package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.eventbus;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.DataUnfiormityProcessor;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * author:gonghongxing
 * date:2023/4/17
 * description:
 **/
@Component
@Slf4j
public class DataUniformitySubscriber {
    @Autowired
    private DataUnfiormityProcessor dataUnfiormityProcessor;

    /**
     * 订阅任务的具体处理
     * @param dataUniformityEvent dataUniformityEvent
     */
    @Subscribe
    public void recordBkCompleted(DataUniformityEvent dataUniformityEvent)
    {
        AuthoredUser authoredUser = dataUniformityEvent.getAuthoredUser();
        DataUniformityEventDTO content = dataUniformityEvent.getContent();
        try
        {
            dataUnfiormityProcessor.recordBkCompleted(authoredUser, content.getBacklogId(),
                    content.getRequestData(), content.getTmActivityId());
        }
        catch (Exception e)
        {
            log.error("deal backlog:{},tmActivity:{} error",content.getBacklogId(),content.getTmActivityId(),e);
        }

    }
}
