/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.atdm.activity.domain.TmQueryAction;
import com.digiwin.athena.atdm.activity.service.BaseTmDataSourceService;
import com.digiwin.athena.atdm.adsc.CommonAdscService;
import com.digiwin.athena.atdm.datasource.DataFetchingService;
import com.digiwin.athena.atdm.datasource.datasource.process.AtmcBatchDataSourceService;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.dto.DataQueryDTO;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.digiwin.athena.atdm.datasource.dto.QueryDataByActionDTO;
import com.digiwin.athena.atdm.datasource.dto.QueryDataByActionIdDTO;
import com.digiwin.athena.atdm.datasource.dto.QueryDataByDataSourceDTO;
import com.digiwin.athena.atdm.esp.CommonESPService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DataQueryServiceWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataQueryServiceWrapper.class);
    @Autowired
    private BaseTmDataSourceService baseTmDataSourceService;
    @Autowired
    private DataFetchingService dataFetchingService;
    @Autowired
    private CommonESPService commonEspService;
    @Autowired
    private CommonAdscService adscService;
    @Resource
    private AtmcBatchDataSourceService atmcBatchDataSourceService;

    public QueryResultSet queryWithMetaData(HttpServletRequest request, DataQueryDTO dataQueryDTO) {
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        LogDto logDto = new LogDto("\u6839\u636e\u4ee3\u529e\u7684\u6570\u636e\u6765\u67e5\u8be2\u83b7\u53d6\u6570\u636e\u5f00\u59cb:", authoredUser.getTenantId());
        log.info(logDto.toString());
        if (dataQueryDTO.getDataSourceSet() == null) {
            dataQueryDTO.setDataSourceSet(dataQueryDTO.getDataSourceSetDTO());
        }
        if (dataQueryDTO.getDataSourceSet() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getDataSourceSet()");
        }
        if (dataQueryDTO.getExecuteContext() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getExecuteContext()");
        }
        dataQueryDTO.getExecuteContext().appendHttpRequest(request);
        dataQueryDTO.getExecuteContext().appendExtend(dataQueryDTO.getSettings());
        DataSourceProcessor dataSourceProcessor = this.dataFetchingService.judgeAbnormalProcessor(dataQueryDTO);
        QueryResultSet queryResult = this.dataFetchingService.queryWithMetaData(dataQueryDTO.getExecuteContext(), dataQueryDTO.getDataSourceSet(), dataQueryDTO.getParameter(), dataQueryDTO.getPageInfo(), dataQueryDTO.getSortInfo(), dataQueryDTO.getSearchInfo());
        this.dataFetchingService.dealQueryResult(queryResult, dataSourceProcessor);
        return queryResult;
    }

    public QueryResultSet queryByBacklog(HttpServletRequest request, DataQueryDTO dataQueryDTO) {
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        LogDto logDto = new LogDto("\u6839\u636e\u4ee3\u529e\u7684\u6570\u636e\u6765\u67e5\u8be2\u83b7\u53d6\u6570\u636e\u5f00\u59cb:", authoredUser.getTenantId());
        log.info(logDto.toString());
        if (dataQueryDTO.getDataSourceSet() == null) {
            dataQueryDTO.setDataSourceSet(dataQueryDTO.getDataSourceSetDTO());
        }
        if (dataQueryDTO.getDataSourceSet() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getDataSourceSetDTO()");
        }
        if (dataQueryDTO.getExecuteContext() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getExecuteContext()");
        }
        dataQueryDTO.getExecuteContext().appendHttpRequest(request);
        return this.dataFetchingService.query(dataQueryDTO.getExecuteContext(), dataQueryDTO.getDataSourceSet(), dataQueryDTO.getParameter(), dataQueryDTO.getPageInfo(), dataQueryDTO.getSortInfo(), dataQueryDTO.getSearchInfo());
    }

    public Map queryPageDataByDatasource(HttpServletRequest request, DataQueryDTO dataQueryDTO) {
        if (dataQueryDTO.getDataSourceSet() == null) {
            dataQueryDTO.setDataSourceSet(dataQueryDTO.getDataSourceSetDTO());
        }
        if (dataQueryDTO.getDataSourceSet() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getDataSourceSet()");
        }
        if (dataQueryDTO.getExecuteContext() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getExecuteContext()");
        }
        dataQueryDTO.getExecuteContext().appendHttpRequest(request);
        this.dataFetchingService.dealDataQueryInfoBeforeQuery(dataQueryDTO);
        QueryResultSet queryResult = this.dataFetchingService.query(dataQueryDTO.getExecuteContext(), dataQueryDTO.getDataSourceSet(), dataQueryDTO.getParameter(), dataQueryDTO.getPageInfo(), dataQueryDTO.getSortInfo(), dataQueryDTO.getSearchInfo());
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> pageData = new HashMap<String, Map<String, Object>>();
        pageData.put("uibot__page__parameter", dataQueryDTO.getParameter());
        if (MapUtils.isEmpty(dataQueryDTO.getParameter())) {
            pageData.put("uibot__page__parameter", new HashMap());
        }
        if (queryResult.getMainQueryResult() != null && !StringUtils.isEmpty((Object)queryResult.getMainQueryResult().getDataSourceName())) {
            pageData.put(queryResult.getMainQueryResult().getDataSourceName(), (Map<String, Object>)queryResult.getPageData().get(queryResult.getMainQueryResult().getDataSourceName()));
        }
        result.put("pageData", pageData);
        result.put("pageDataIndex", queryResult.getPageDataIndex());
        result.put("pageDataKeys", queryResult.getPageDataKeys());
        result.put("pageCountSize", queryResult.getMainQueryResult().size());
        result.put("returnRequestData", queryResult.getMainQueryResult().getReturnRequestData());
        this.dataFetchingService.queryInfo(dataQueryDTO, queryResult, result);
        this.dataFetchingService.dealPageDataAfterQuery(dataQueryDTO, queryResult, result);
        return result;
    }

    public Integer querySize(HttpServletRequest request, DataQueryDTO dataQueryDTO) {
        if (dataQueryDTO.getDataSourceSet() == null) {
            dataQueryDTO.setDataSourceSet(dataQueryDTO.getDataSourceSetDTO());
        }
        if (dataQueryDTO.getDataSource() == null) {
            dataQueryDTO.setDataSource(dataQueryDTO.getDataSourceDTO());
        }
        if (dataQueryDTO.getDataSource() == null && dataQueryDTO.getDataSourceSet() != null && CollectionUtils.isNotEmpty((Collection)dataQueryDTO.getDataSourceSet().getDataSourceList())) {
            dataQueryDTO.setDataSource((DataSourceDTO)dataQueryDTO.getDataSourceSet().getDataSourceList().get(0));
        }
        if (dataQueryDTO.getDataSource() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getDataSource()");
        }
        if (dataQueryDTO.getExecuteContext() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getExecuteContext()");
        }
        dataQueryDTO.getExecuteContext().appendHttpRequest(request);
        return this.dataFetchingService.size(dataQueryDTO);
    }

    public Map querySizeByDataSize(HttpServletRequest request, DataQueryDTO dataQueryDTO) {
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        LogDto logDto = new LogDto("\u6839\u636e\u4ee3\u529e\u7684\u6570\u636e\u6765\u67e5\u8be2\u83b7\u53d6\u6570\u636esize\u5f00\u59cb:", authoredUser.getTenantId());
        log.info(logDto.toString());
        if (dataQueryDTO.getDataSourceSet() == null) {
            dataQueryDTO.setDataSourceSet(dataQueryDTO.getDataSourceSetDTO());
        }
        if (dataQueryDTO.getDataSource() == null) {
            dataQueryDTO.setDataSource(dataQueryDTO.getDataSourceDTO());
        }
        if (dataQueryDTO.getDataSource() == null && dataQueryDTO.getDataSourceSet() != null && CollectionUtils.isNotEmpty((Collection)dataQueryDTO.getDataSourceSet().getDataSourceList())) {
            dataQueryDTO.setDataSource((DataSourceDTO)dataQueryDTO.getDataSourceSet().getDataSourceList().get(0));
        }
        if (dataQueryDTO.getDataSource() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getDataSource()");
        }
        if (dataQueryDTO.getExecuteContext() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getExecuteContext()");
        }
        dataQueryDTO.getExecuteContext().appendHttpRequest(request);
        if (dataQueryDTO.getDataSourceSet().getDataSourceList() != null && dataQueryDTO.getDataSourceSet().getDataSourceList().size() > 1) {
            Map<String, List<DataSourceDTO>> groupDs = dataQueryDTO.getDataSourceSet().getDataSourceList().stream().collect(Collectors.groupingBy(DataSourceDTO::getName));
            dataQueryDTO.getDataSourceSet().getDataSourceList().clear();
            for (List list : groupDs.values()) {
                if (list.size() > 1) {
                    DataSourceDTO allDs = new DataSourceDTO();
                    allDs.setType("MIX_UNION");
                    allDs.setUnionItems(list);
                    allDs.setName(((DataSourceDTO)list.get(0)).getName());
                    allDs.setDataKeys(((DataSourceDTO)list.get(0)).getDataKeys());
                    dataQueryDTO.getDataSourceSet().getDataSourceList().add(allDs);
                    continue;
                }
                dataQueryDTO.getDataSourceSet().getDataSourceList().add(list.get(0));
            }
            if (dataQueryDTO.getDataSourceSet().getDataSourceList().size() == 1) {
                dataQueryDTO.setDataSource((DataSourceDTO)dataQueryDTO.getDataSourceSet().getDataSourceList().get(0));
                dataQueryDTO.getDataSourceSet().getDataSourceList().clear();
            }
        }
        int size = 0;
        if (dataQueryDTO.getDataSourceSet().getDataSourceList() != null && dataQueryDTO.getDataSourceSet().getDataSourceList().size() > 1) {
            for (DataSourceDTO dataSourceDTO : dataQueryDTO.getDataSourceSet().getDataSourceList()) {
                if (!dataQueryDTO.getDataSourceSet().getMainDatasource().equals(dataSourceDTO.getName())) continue;
                size += this.dataFetchingService.size(dataQueryDTO, dataSourceDTO);
            }
        } else if (dataQueryDTO.getDataSourceSet().getMainDatasource().equals(dataQueryDTO.getDataSource().getName())) {
            size = this.dataFetchingService.size(dataQueryDTO);
        }
        return MapUtil.of((Object)"size", (Object)size);
    }

    public QueryResult queryByDatasource(HttpServletRequest request, QueryDataByDataSourceDTO queryDataByActionVO, AuthoredUser user) {
        ExecuteContext executeContext = queryDataByActionVO.getExecuteContext();
        if (executeContext != null) {
            executeContext.appendHttpRequest(request);
        } else {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        }
        executeContext.setBusinessUnit(queryDataByActionVO.getBusinessUnit());
        if (queryDataByActionVO.getDataSource() == null) {
            throw new IllegalArgumentException("queryDataByActionVO.getDataSource()");
        }
        return this.dataFetchingService.querySingleResult(executeContext, queryDataByActionVO.getDataSource(), queryDataByActionVO.getParameter(), queryDataByActionVO.getPageInfo(), queryDataByActionVO.getSortInfo(), queryDataByActionVO.getSearchInfo());
    }

    public Map actionData(HttpServletRequest request, QueryDataByActionDTO queryDataByActionDTO, AuthoredUser user) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.setBusinessUnit(queryDataByActionDTO.getBusinessUnit());
        TmQueryAction tmAction = queryDataByActionDTO.getTmAction();
        DataSourceDTO dataSourceBase = null;
        if (queryDataByActionDTO.getBpmData() != null) {
            dataSourceBase = this.baseTmDataSourceService.analysis(executeContext, "data", tmAction, queryDataByActionDTO.getBpmData());
        } else if (queryDataByActionDTO.getParas() != null) {
            dataSourceBase = this.baseTmDataSourceService.analysisHasParas(executeContext, "data", tmAction, queryDataByActionDTO.getParas());
        }
        QueryResult queryResult = this.dataFetchingService.querySingleResult(executeContext, dataSourceBase, null, queryDataByActionDTO.getPageInfo(), queryDataByActionDTO.getSortInfo(), queryDataByActionDTO.getSearchInfo());
        return queryResult.getPageData();
    }

    public Map queryByActionId(HttpServletRequest request, QueryDataByActionIdDTO queryDataByActionDTO, AuthoredUser user) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.setBusinessUnit(queryDataByActionDTO.getBusinessUnit());
        if (StringUtils.isEmpty((Object)queryDataByActionDTO.getActionId())) {
            throw new IllegalArgumentException("actionId \u4e3a\u7a7a");
        }
        if (Objects.nonNull(queryDataByActionDTO.getExecuteContext())) {
            String application = queryDataByActionDTO.getExecuteContext().getApplication();
            executeContext.setApplication(application);
        }
        return this.commonEspService.queryByApiName(executeContext, queryDataByActionDTO.getActionId(), queryDataByActionDTO.getParameter(), queryDataByActionDTO.getPageInfo(), queryDataByActionDTO.getSortInfo(), queryDataByActionDTO.getSearchInfo());
    }

    public Map querySizeByDataSizeAbnormal(HttpServletRequest request, DataQueryDTO dataQueryDTO) {
        if (dataQueryDTO.getDataSourceSet() == null) {
            dataQueryDTO.setDataSourceSet(dataQueryDTO.getDataSourceSetDTO());
        }
        if (dataQueryDTO.getDataSource() == null) {
            dataQueryDTO.setDataSource(dataQueryDTO.getDataSourceDTO());
        }
        if (dataQueryDTO.getDataSource() == null && dataQueryDTO.getDataSourceSet() != null && CollectionUtils.isNotEmpty((Collection)dataQueryDTO.getDataSourceSet().getDataSourceList())) {
            dataQueryDTO.setDataSource((DataSourceDTO)dataQueryDTO.getDataSourceSet().getDataSourceList().get(0));
        }
        if (dataQueryDTO.getDataSource() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getDataSource()");
        }
        if (dataQueryDTO.getExecuteContext() == null) {
            throw new IllegalArgumentException("queryDataByActivityDTO.getExecuteContext()");
        }
        dataQueryDTO.getExecuteContext().appendHttpRequest(request);
        if (dataQueryDTO.getDataSourceSet().getDataSourceList() != null && dataQueryDTO.getDataSourceSet().getDataSourceList().size() > 1) {
            Map<String, List<DataSourceDTO>> groupDs = dataQueryDTO.getDataSourceSet().getDataSourceList().stream().collect(Collectors.groupingBy(DataSourceDTO::getName));
            dataQueryDTO.getDataSourceSet().getDataSourceList().clear();
            for (List<DataSourceDTO> dataSourceDTOS : groupDs.values()) {
                if (dataSourceDTOS.size() > 1) {
                    DataSourceDTO allDs = new DataSourceDTO();
                    allDs.setType("MIX_UNION");
                    allDs.setUnionItems((List)dataSourceDTOS);
                    allDs.setName(((DataSourceDTO)dataSourceDTOS.get(0)).getName());
                    allDs.setDataKeys(((DataSourceDTO)dataSourceDTOS.get(0)).getDataKeys());
                    dataQueryDTO.getDataSourceSet().getDataSourceList().add(allDs);
                    continue;
                }
                dataQueryDTO.getDataSourceSet().getDataSourceList().add(dataSourceDTOS.get(0));
            }
            if (dataQueryDTO.getDataSourceSet().getDataSourceList().size() == 1) {
                dataQueryDTO.setDataSource((DataSourceDTO)dataQueryDTO.getDataSourceSet().getDataSourceList().get(0));
                dataQueryDTO.getDataSourceSet().getDataSourceList().clear();
            }
        }
        Integer size = 0;
        Integer abnormalSize = 0;
        if (dataQueryDTO.getDataSourceSet().getDataSourceList() != null && dataQueryDTO.getDataSourceSet().getDataSourceList().size() > 1) {
            for (DataSourceDTO dataSource : dataQueryDTO.getDataSourceSet().getDataSourceList()) {
                if (!dataQueryDTO.getDataSourceSet().getMainDatasource().equals(dataSource.getName())) continue;
                Map<String, Integer> sizeMap = this.dataFetchingService.getDataSize(dataQueryDTO.getExecuteContext(), dataSource, dataQueryDTO.getParameter(), dataQueryDTO.getRowSizeType());
                size = size + sizeMap.get("size");
                abnormalSize = abnormalSize + sizeMap.get("abnormalSize");
            }
        } else if (dataQueryDTO.getDataSourceSet().getMainDatasource().equals(dataQueryDTO.getDataSource().getName())) {
            Map<String, Integer> sizeMap = this.dataFetchingService.getDataSize(dataQueryDTO.getExecuteContext(), dataQueryDTO.getDataSource(), dataQueryDTO.getParameter(), dataQueryDTO.getRowSizeType());
            size = sizeMap.get("size");
            abnormalSize = sizeMap.get("abnormalSize");
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("size", size);
        result.put("abnormalSize", abnormalSize);
        return result;
    }
}

