/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ScriptEngineUtils;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.CheckItem;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="checkItemService")
public class CheckItemsServiceSource
implements DataSourceProcessService {
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
    }

    private void addCheckItemsData(List<CheckItem> checkItems, List<Map<String, Object>> apiData) {
        if (CollectionUtils.isEmpty(apiData)) {
            return;
        }
        for (Map<String, Object> datum : apiData) {
            ArrayList checkDataList = new ArrayList();
            for (CheckItem checkItem : checkItems) {
                Object checkValue;
                HashMap<String, Object> checkData = new HashMap<String, Object>();
                checkData.put("key", checkItem.getKey());
                checkData.put("name", checkItem.getName());
                if (StringUtils.hasText((String)checkItem.getScript())) {
                    if ("true".equals(checkItem.getScript())) {
                        checkData.put("yesOrNo", false);
                    } else if ("false".equals(checkItem.getScript())) {
                        checkData.put("yesOrNo", true);
                    } else {
                        checkValue = ScriptEngineUtils.getInstance().evalScript(checkItem.getScript(), datum);
                        checkData.put("yesOrNo", (Boolean)checkValue == false);
                    }
                } else if (datum.containsKey(checkItem.getKey())) {
                    checkValue = datum.get(checkItem.getKey());
                    checkData.put("yesOrNo", (Boolean)checkValue == false);
                } else {
                    checkData.put("yesOrNo", false);
                }
                if (datum.containsKey(checkItem.getStandardValue())) {
                    checkData.put("standardValue", datum.get(checkItem.getStandardValue()));
                }
                if (datum.containsKey(checkItem.getValue())) {
                    checkData.put("value", datum.get(checkItem.getValue()));
                }
                checkDataList.add(checkData);
            }
            datum.put("check_result", checkDataList);
        }
    }

    private void addCheckItemFiled(ApiMetadataCollection apiMetadataCollection, String pageCode) {
        if (apiMetadataCollection == null) {
            return;
        }
        MetadataField metadataField = new MetadataField();
        metadataField.setArray(Boolean.valueOf(true));
        metadataField.setUiBot("Y");
        metadataField.setName("check_result");
        if ("project-detail".equals(pageCode)) {
            metadataField.setTagDefinitions(CustomizeTagUtils.createOrderTagDefinitions("999"));
        }
        metadataField.setDescription(this.messageUtils.getMessage("uibot.acitivity.check.title"));
        metadataField.setDataType("object");
        ArrayList<MetadataField> subFields = new ArrayList<MetadataField>();
        MetadataField keyMetadataField = new MetadataField();
        keyMetadataField.setUiBot("Y");
        keyMetadataField.setArray(Boolean.valueOf(false));
        keyMetadataField.setName("key");
        keyMetadataField.setDataType("string");
        subFields.add(keyMetadataField);
        MetadataField valueMetadataField = new MetadataField();
        valueMetadataField.setArray(Boolean.valueOf(false));
        valueMetadataField.setUiBot("Y");
        valueMetadataField.setName("value");
        valueMetadataField.setDataType("string");
        subFields.add(valueMetadataField);
        MetadataField nameMetadataField = new MetadataField();
        nameMetadataField.setArray(Boolean.valueOf(false));
        nameMetadataField.setUiBot("Y");
        nameMetadataField.setName("name");
        nameMetadataField.setDataType("string");
        subFields.add(nameMetadataField);
        MetadataField yesOrNoMetadataField = new MetadataField();
        yesOrNoMetadataField.setArray(Boolean.valueOf(false));
        yesOrNoMetadataField.setUiBot("Y");
        yesOrNoMetadataField.setName("yesOrNo");
        yesOrNoMetadataField.setDataType("boolean");
        subFields.add(yesOrNoMetadataField);
        MetadataField standardValueMetadataField = new MetadataField();
        standardValueMetadataField.setArray(Boolean.valueOf(false));
        standardValueMetadataField.setUiBot("Y");
        standardValueMetadataField.setName("standardValue");
        standardValueMetadataField.setDataType("string");
        subFields.add(standardValueMetadataField);
        metadataField.setSubFields(subFields);
        if (apiMetadataCollection.getMasterApiMetadata() != null && CollectionUtils.isNotEmpty((Collection)apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {
            ((MetadataField)apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields().add(metadataField);
        }
    }
}

