package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.lcdp.CommonLcdpService;
import com.digiwin.athena.atdm.constant.Variables;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.util.SearchInfoUtil;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Data
public class
LcdpDataSource extends DataSourceBase {


    public LcdpDataSource( ){
        super();
        this.setType(UiBotConstants.DATA_LCDP);
    }


    /**
     * 查询数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @return
     */
    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo) {
        if (this.getAction() == null) {
            return QueryResult.empty(this.getName());
        }

        Map paras = this.getAction().getParas();
        //处理分页信息
        if (pageInfo != null){
            if (!pageInfo.isNextAllData()){
                paras.put("use_has_next", true);
                if (pageInfo.getPageSize() != null) {
                    paras.put("page_size", pageInfo.getPageSize());
                }
                if (pageInfo.getPageNo() != null) {
                    paras.put("page_no", pageInfo.getPageNo());
                }
            }
        }
        //排序
        if (CollectionUtils.isNotEmpty(sortInfo)) {
            List<Map> newSortInfo = new ArrayList<>();
            for (Map item : sortInfo) {
                if (StringUtils.hasText( item.getOrDefault("schema","").toString())) {
                    //兼容处理
                    if (item.get("orderType") != null
                            && item.get("orderType").toString().contains("desc")) {
                        item.put("orderType","desc");
                    }else{
                        item.put("orderType","asc");
                    }
                    Map<String, Object> sortItem = new HashMap<>();
                    sortItem.put("sort_field", item.get("schema"));
                    sortItem.put("sort_type", item.get("orderType"));
                    sortItem.put("sort_seq", item.get("order"));
                    newSortInfo.add(sortItem);
                }
            }
            paras.put("sort_info", newSortInfo);
        }
        //查询
        if (CollectionUtils.isNotEmpty(searchInfo)) {
            paras.put(Variables.SEARCH_VALUE, "");
            paras.put(Variables.SEARCH_INFO, SearchInfoUtil.mergeSearchInfo((List<Map>) paras.get(Variables.SEARCH_INFO), searchInfo));
        }

        if (parameter != null && this.getAction().getParas() == null && this.getAction().getActionParams() == null) {
            this.getAction().setParas(new HashMap<>());
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                this.getAction().getParas().put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
        }
        //查询数据
        HashMap<String,Object> data = SpringUtil.getBean(CommonLcdpService.class).query(executeContext,this.getAction());

        if (data == null || data.size() == 0){
            return QueryResult.empty(this.getName());
        }else {
            QueryResult queryResult = QueryResult.withData(this.getName(),data,pageInfo);
            Set<String> keys = data.keySet();
            //从esp的结果中填充分页数据
            if (keys.size() >0){
                if (keys.contains("has_next") && data.get("has_next")!=null){
                    queryResult.setHasNext((Boolean)data.get("has_next"));
                }
                if (keys.contains("total_results") && data.get("total_results")!=null){
                    queryResult.setTotalResults( (Integer)data.get("total_results"));
                }
            }
            return queryResult;
        }
    }

    /**
     * 附加数据的元数据
     *
     * @param executeContext   执行上下文
     * @param parameter        参数
     * @param queryResult      查询结果
     * @return
     */
    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext,  Map<String, Object> parameter, QueryResult queryResult) {
        //查询元数据
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        //ApiMetadata apiMetadata =SpringUtil.getBean(MetadataService.class).getMetadata(executeContext.getLocale(), this.getAction().getActionId());
        apiMetadataCollection.setMasterApiMetadata(new ApiMetadata());
        return apiMetadataCollection;
    }


    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        LcdpDataSource lcdpDataSource = new LcdpDataSource();
        lcdpDataSource.setName(this.getName());
        lcdpDataSource.setAction(this.getAction());
        lcdpDataSource.setType(this.getType());
        lcdpDataSource.setDataKeys(this.getDataKeys());
        lcdpDataSource.setActionId(this.getActionId());
        return lcdpDataSource;
    }
}
