/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.process.ActivityUtils;
import com.digiwin.athena.atdm.datasource.datasource.process.ApprovalUtil;
import com.digiwin.athena.atdm.datasource.datasource.process.AtmcDataSourceService;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import com.digiwin.athena.atdm.datasource.datasource.process.DeriveUtil;
import com.digiwin.athena.atdm.datasource.datasource.process.SolveUtil;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.BusinessKeyMappingDTO;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.TaskWithBacklogData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="atmcBatchDataService")
public class AtmcBatchDataSourceService
implements DataSourceProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtmcBatchDataSourceService.class);
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private CommonAtmcService atmcService;
    @Value(value="${process.atmcBatch.dealAsync:false}")
    private String dealAsync;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (!"task-detail".equals(executeContext.getPageCode()) && !"project-detail".equals(executeContext.getPageCode())) {
            return;
        }
        this.addAtmcFiled(dataSourceBase, executeContext, dataSourceProcessor, queryResult.getApiMetadataCollection());
    }

    private void addBatchProcessorDataForDatasource(DataSourceProcessor dataSourceProcessor, ExecuteContext executeContext) {
        try {
            boolean isSimplified = Boolean.TRUE.equals(executeContext.getEnableSimplifyPack());
            boolean isStandardWeb = "standardweb".equals(executeContext.getAgentType());
            if (!CollectionUtils.isEmpty((Collection)dataSourceProcessor.getTaskWithBacklogDataList())) {
                return;
            }
            if (isSimplified && isStandardWeb || Boolean.TRUE.equals(dataSourceProcessor.getHasTaskData())) {
                List taskWithBacklogDataList = this.atmcService.getTaskData(executeContext.getPtmBacklogId(), executeContext).getTasks();
                dataSourceProcessor.setTaskWithBacklogDataList(taskWithBacklogDataList);
            }
        }
        catch (Exception e) {
            log.warn("addBatchProcessorDataForDatasource exception {}", (Object)e.getMessage());
        }
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        Map processParas;
        if (!"task-detail".equals(executeContext.getPageCode()) && !"project-detail".equals(executeContext.getPageCode())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)queryResult.getData())) {
            return;
        }
        if (Objects.isNull(dataSourceProcessor.getMappingKeys())) {
            return;
        }
        this.addBatchProcessorDataForDatasource(dataSourceProcessor, executeContext);
        if (CollectionUtils.isEmpty((Collection)dataSourceProcessor.getTaskWithBacklogDataList())) {
            return;
        }
        String mainDataName = dataSourceProcessor.getMappingKeys().getDataName();
        List<String> keyList = this.parseMappingKeys(dataSourceProcessor.getMappingKeys());
        String detailField = null;
        if (dataSourceProcessor.getParas() != null && (processParas = (Map)dataSourceProcessor.getParas()).containsKey("detailField")) {
            detailField = (String)processParas.get("detailField");
        }
        List taskWithBacklogDataLists = dataSourceProcessor.getTaskWithBacklogDataList();
        Map<String, TaskWithBacklogData> taskWithBacklogIndexMap = this.dealBpmDataByMapKeys(keyList, mainDataName, taskWithBacklogDataLists);
        String detailFieldFinal = detailField;
        if (Boolean.TRUE.equals(Boolean.valueOf(this.dealAsync))) {
            this.dealMultiPartAsync(executeContext, queryResult.getData(), taskWithBacklogIndexMap, keyList, detailFieldFinal);
        } else {
            this.dealResultData(executeContext, queryResult.getData(), taskWithBacklogIndexMap, keyList, detailFieldFinal);
        }
        for (TaskWithBacklogData taskWithBacklogData : taskWithBacklogDataLists) {
            if (!"SOLVE".equals(executeContext.getCategory()) || !"waitting".equals(executeContext.getDataStateCode()) || taskWithBacklogData.getBpmData() == null || !taskWithBacklogData.getBpmData().containsKey("checkResult") || !Objects.nonNull(dataSourceBase)) continue;
            this.addCheckResult(dataSourceBase, queryResult, taskWithBacklogData);
        }
    }

    private void dealMultiPartAsync(ExecuteContext executeContext, List<Map<String, Object>> data, Map<String, TaskWithBacklogData> taskWithBacklogIndexMap, List<String> keyList, String detailFieldFinal) {
        ExecutorService executorService = (ExecutorService)SpringUtil.getBean((String)"asyncServiceExecutor");
        int batchsize = 500;
        int maxBatchNum = 50;
        int totalDataSize = data.size();
        if (totalDataSize / batchsize > maxBatchNum) {
            batchsize = totalDataSize / maxBatchNum;
        }
        int mod = totalDataSize % batchsize;
        int batchNum = totalDataSize / batchsize + (mod > 0 ? 1 : 0);
        CompletableFuture[] completableFutureList = new CompletableFuture[batchNum];
        for (int i = 0; i < batchNum; ++i) {
            CompletableFuture<Void> completableFuture;
            int fromIdx = i * batchsize;
            int toIdx = fromIdx + (i == batchNum - 1 && mod > 0 ? mod : batchsize);
            completableFutureList[i] = completableFuture = CompletableFuture.runAsync(() -> this.dealResultData(executeContext, data.subList(fromIdx, toIdx), taskWithBacklogIndexMap, keyList, detailFieldFinal), executorService);
        }
        log.info("[AtmcBatchDataSourceService]\u6279\u91cf\u5f02\u6b65\u5904\u7406\uff0c\u603b\u6570[{}],\u6279\u6570[{}],\u6bcf\u6279\u5927\u5c0f[{}]", new Object[]{totalDataSize, batchNum, batchsize});
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(completableFutureList);
        try {
            allFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.error("\u5f02\u6b65\u6267\u884cfutureDealResultData\u64cd\u4f5c\u5f02\u5e38[{}]", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0118.getErrCode(), (String)this.messageUtils.getMessage("delivery.AtmcBatchDataSourceService.dealAsyncError"));
        }
    }

    private void addCheckResult(DataSourceBase dataSourceBase, QueryResult queryResult, TaskWithBacklogData taskWithBacklogData) {
        List checkResult = (List)taskWithBacklogData.getBpmData().get("checkResult");
        if (!CollectionUtils.isEmpty(dataSourceBase.getDataKeys())) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map datum : checkResult) {
                String key;
                Map findItem;
                stringBuilder.setLength(0);
                for (String key2 : dataSourceBase.getDataKeys()) {
                    if (datum.containsKey(key2)) {
                        stringBuilder.append(StringUtils.isEmpty(datum.get(key2)) ? "NAN" : datum.get(key2).toString()).append(";");
                        continue;
                    }
                    stringBuilder.append("NAN;");
                }
                if (stringBuilder.length() <= 0 || (findItem = queryResult.findByKey(key = stringBuilder.toString())) == null) continue;
                findItem.put("check_result", datum.get("result"));
            }
        }
    }

    private void addAtmcFiled(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, ApiMetadataCollection apiMetadataCollection) {
        if (apiMetadataCollection == null || apiMetadataCollection.getMasterApiMetadata() == null || apiMetadataCollection.getMasterApiMetadata().getResponseFields() == null || apiMetadataCollection.getMasterApiMetadata().getResponseFields().size() == 0) {
            return;
        }
        MetadataField performerNameMetadataField = new MetadataField();
        performerNameMetadataField.setUiBot("Y");
        performerNameMetadataField.setName("activity__performerName");
        performerNameMetadataField.setDataType("string");
        performerNameMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.performerName"));
        MetadataField planEndTimeMetadataField = new MetadataField();
        planEndTimeMetadataField.setUiBot("Y");
        planEndTimeMetadataField.setName("activity__planEndTime");
        planEndTimeMetadataField.setDataType("string");
        planEndTimeMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.planEndTime"));
        MetadataField readCountMetadataField = new MetadataField();
        readCountMetadataField.setUiBot("Y");
        readCountMetadataField.setName("activity__readCount");
        readCountMetadataField.setDataType("string");
        readCountMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.readCount"));
        MetadataField dataStatusMetadataField = new MetadataField();
        dataStatusMetadataField.setUiBot("Y");
        dataStatusMetadataField.setName("activity__backLog__data");
        dataStatusMetadataField.setDataType("object");
        dataStatusMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.dataStatus"));
        List metadataFields = ((MetadataField)apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields();
        metadataFields.add(performerNameMetadataField);
        metadataFields.add(planEndTimeMetadataField);
        metadataFields.add(readCountMetadataField);
        metadataFields.add(dataStatusMetadataField);
        ActivityUtils.addActivityMetadataField(metadataFields, this.messageUtils);
        if (!"SHELVED_DATA".equals(dataSourceBase.getType())) {
            metadataFields.add(this.createDataFlowStatusField());
        }
        MetadataField prePerformerNameMetadataField = null;
        MetadataField prePerformerIdMetadataField = null;
        MetadataField dataTranceStatusMetadataField = null;
        MetadataField checkResultMetadataField = null;
        if (CollectionUtils.isEmpty((Collection)dataSourceProcessor.getTaskWithBacklogDataList())) {
            return;
        }
        List taskWithBacklogDataList = dataSourceProcessor.getTaskWithBacklogDataList();
        for (TaskWithBacklogData taskWithBacklogData : taskWithBacklogDataList) {
            if ("SOLVE".equals(executeContext.getCategory()) || "APPROVAL".equals(executeContext.getCategory()) && executeContext.getIdentity().equals("charge")) {
                BacklogData firstBacklogData;
                if (!(CollectionUtils.isEmpty((Collection)taskWithBacklogData.getBacklog()) || (firstBacklogData = (BacklogData)taskWithBacklogData.getBacklog().get(0)).getPrePerformerId() == null && firstBacklogData.getPreAgentPerformerId() == null)) {
                    prePerformerNameMetadataField = new MetadataField();
                    prePerformerNameMetadataField.setUiBot("Y");
                    prePerformerNameMetadataField.setName("activity__prePerformer_Name");
                    prePerformerNameMetadataField.setDataType("string");
                    prePerformerNameMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.performerName"));
                    prePerformerIdMetadataField = new MetadataField();
                    prePerformerIdMetadataField.setUiBot("Y");
                    prePerformerIdMetadataField.setName("activity__prePerformer_Id");
                    prePerformerIdMetadataField.setDataType("string");
                    prePerformerIdMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.performerName"));
                }
                dataTranceStatusMetadataField = new MetadataField();
                dataTranceStatusMetadataField.setUiBot("Y");
                dataTranceStatusMetadataField.setName("activity__approval__state");
                dataTranceStatusMetadataField.setDataType("string");
                dataTranceStatusMetadataField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.approvalStatus"));
                if (taskWithBacklogData.getBpmData() == null || !"waitting".equals(executeContext.getDataStateCode()) || !taskWithBacklogData.getBpmData().containsKey("checkResult")) break;
                checkResultMetadataField = new MetadataField();
                checkResultMetadataField.setArray(Boolean.valueOf(true));
                checkResultMetadataField.setUiBot("Y");
                checkResultMetadataField.setName("check_result");
                if ("task-detail".equals(executeContext.getPageCode()) || "project-detail".equals(executeContext.getPageCode())) {
                    checkResultMetadataField.setTagDefinitions(CustomizeTagUtils.createOrderTagDefinitions("999"));
                }
                checkResultMetadataField.setDescription(this.messageUtils.getMessage("uibot.acitivity.check.title"));
                checkResultMetadataField.setDataType("object");
                ArrayList<MetadataField> subFields = new ArrayList<MetadataField>();
                MetadataField keyMetadataField = new MetadataField();
                keyMetadataField.setUiBot("Y");
                keyMetadataField.setArray(Boolean.valueOf(false));
                keyMetadataField.setName("key");
                keyMetadataField.setDataType("string");
                subFields.add(keyMetadataField);
                MetadataField nameMetadataField = new MetadataField();
                nameMetadataField.setArray(Boolean.valueOf(false));
                nameMetadataField.setUiBot("Y");
                nameMetadataField.setName("name");
                nameMetadataField.setDataType("string");
                subFields.add(nameMetadataField);
                MetadataField standardValueMetadataField = new MetadataField();
                standardValueMetadataField.setArray(Boolean.valueOf(false));
                standardValueMetadataField.setUiBot("Y");
                standardValueMetadataField.setName("standardValue");
                standardValueMetadataField.setDataType("string");
                subFields.add(standardValueMetadataField);
                MetadataField valueMetadataField = new MetadataField();
                valueMetadataField.setArray(Boolean.valueOf(false));
                valueMetadataField.setUiBot("Y");
                valueMetadataField.setName("value");
                valueMetadataField.setDataType("string");
                subFields.add(valueMetadataField);
                MetadataField dropValueMetadataField = new MetadataField();
                dropValueMetadataField.setArray(Boolean.valueOf(false));
                dropValueMetadataField.setUiBot("Y");
                dropValueMetadataField.setName("dropValue");
                dropValueMetadataField.setDataType("string");
                subFields.add(dropValueMetadataField);
                MetadataField yesOrNoMetadataField = new MetadataField();
                yesOrNoMetadataField.setArray(Boolean.valueOf(false));
                yesOrNoMetadataField.setUiBot("Y");
                yesOrNoMetadataField.setName("yesOrNo");
                yesOrNoMetadataField.setDataType("boolean");
                subFields.add(yesOrNoMetadataField);
                checkResultMetadataField.setSubFields(subFields);
                break;
            }
            if (!"DERIVE".equals(executeContext.getPattern()) || taskWithBacklogData.getBpmData() == null || !taskWithBacklogData.getBpmData().containsKey("__DERIVE_TASK_RELATION")) continue;
            HashMap task = (HashMap)taskWithBacklogData.getBpmData().get("__DERIVE_TASK_RELATION");
            if (task == null || task.size() <= 0) break;
            for (Object key : task.keySet()) {
                MetadataField subTaskMetadataField = new MetadataField();
                subTaskMetadataField.setUiBot("Y");
                subTaskMetadataField.setName("uibot__" + key + "__subTask");
                subTaskMetadataField.setDataType("object");
                subTaskMetadataField.setDescription(key + "\u5173\u8054\u7684\u5b50\u4efb\u52a1");
                metadataFields.add(subTaskMetadataField);
            }
        }
        if (null != prePerformerIdMetadataField) {
            metadataFields.add(prePerformerIdMetadataField);
        }
        if (null != prePerformerNameMetadataField) {
            metadataFields.add(prePerformerNameMetadataField);
        }
        if (null != dataTranceStatusMetadataField) {
            metadataFields.add(dataTranceStatusMetadataField);
        }
        if (null != checkResultMetadataField) {
            metadataFields.add(checkResultMetadataField);
        }
    }

    private Map<String, TaskWithBacklogData> dealBpmDataByMapKeys(List<String> mapKeys, String mainDataName, List<TaskWithBacklogData> taskWithBacklogDataList) {
        HashMap<String, TaskWithBacklogData> backlogIndexMap = new HashMap<String, TaskWithBacklogData>(20);
        for (TaskWithBacklogData tmpData : taskWithBacklogDataList) {
            List bpmDataList;
            if (tmpData.getBpmData() == null || !tmpData.getBpmData().containsKey(mainDataName) || CollectionUtils.isEmpty((Collection)tmpData.getBacklog()) || CollectionUtils.isEmpty((Collection)(bpmDataList = (List)MapUtils.getObject((Map)tmpData.getBpmData(), (Object)mainDataName)))) continue;
            bpmDataList.forEach(bpm -> {
                String result = this.generateIndexKey(mapKeys, (Map)bpm);
                if (!StringUtils.isEmpty((Object)result)) {
                    backlogIndexMap.put(result, tmpData);
                }
            });
        }
        return backlogIndexMap;
    }

    private <T> String generateIndexKey(List<String> mapKeys, Map<String, T> map) {
        int i = 0;
        for (String tempKey : mapKeys) {
            if (!map.containsKey(tempKey)) continue;
            ++i;
        }
        StringBuilder indexKey = new StringBuilder();
        if (i == mapKeys.size()) {
            for (String tempKey : mapKeys) {
                indexKey.append(MapUtils.getString(map, (Object)tempKey));
            }
        }
        return indexKey.toString();
    }

    private List<String> parseMappingKeys(BusinessKeyMappingDTO mappingDTO) {
        ArrayList<String> dataNameList = new ArrayList<String>();
        for (BusinessKeyMappingDTO childMapping : mappingDTO.getField()) {
            dataNameList.add(childMapping.getDataName());
        }
        return dataNameList;
    }

    private MetadataField createDataFlowStatusField() {
        MetadataField dataFlowStatusField = new MetadataField();
        dataFlowStatusField.setUiBot("Y");
        dataFlowStatusField.setName("activity__data__status");
        dataFlowStatusField.setDataType("object");
        dataFlowStatusField.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.dataFlowStatus"));
        return dataFlowStatusField;
    }

    public void dealResultData(ExecuteContext executeContext, List<Map<String, Object>> dataList, Map<String, TaskWithBacklogData> taskWithBacklogIndexMap, List<String> keyList, String detailFieldFinal) {
        boolean isPerformer = AtmcDataSourceService.isPerformer(executeContext.getSettings());
        boolean IS_SOLVE_CATEGORY = "SOLVE".equals(executeContext.getCategory());
        boolean IS_APPROVAL_CATEGORY = "APPROVAL".equals(executeContext.getCategory());
        boolean IS_DERIVE_PATTERN = "DERIVE".equals(executeContext.getPattern());
        boolean IS_IDENTITY_CHARGE = executeContext.getIdentity().equals("charge");
        boolean IS_IDENTITY_PERFORMER = executeContext.getIdentity().equals("performer");
        for (Map<String, Object> data : dataList) {
            boolean hasBusinessUnit;
            String taskIndexKey = this.generateIndexKey(keyList, data);
            TaskWithBacklogData taskWithBacklogData = taskWithBacklogIndexMap.get(taskIndexKey);
            if (taskWithBacklogData == null || CollectionUtils.isEmpty((Collection)taskWithBacklogData.getBacklog())) continue;
            BacklogData firstBacklogData = (BacklogData)taskWithBacklogData.getBacklog().get(0);
            if (!isPerformer) {
                firstBacklogData.setPerformerState(null);
            }
            boolean hasPrePerformerId = firstBacklogData.getPrePerformerId() != null || firstBacklogData.getPreAgentPerformerId() != null;
            firstBacklogData.setProcessSerialNumber(taskWithBacklogData.getProcessSerialNumber());
            firstBacklogData.setTaskUid(taskWithBacklogData.getTaskUid());
            HashMap<String, Object> activityDataStatus = new HashMap<String, Object>();
            activityDataStatus.put("withdraw", AtmcDataSourceService.isTaskWithdraw(firstBacklogData));
            activityDataStatus.put("returnInfo", ApprovalUtil.addReturnComments(firstBacklogData, data));
            data.put("activity__data__status", activityDataStatus);
            data.put("activity__backLog__data", firstBacklogData);
            data.put("activity__remainTime", firstBacklogData.getRemainTime());
            data.put("activity__performerName", firstBacklogData.getPerformerName());
            if (hasPrePerformerId) {
                if (firstBacklogData.getPrePerformerType() != null && firstBacklogData.getPrePerformerType() > 0) {
                    data.put("activity__prePerformer_Id", firstBacklogData.getPreAgentPerformerId());
                    data.put("activity__prePerformer_Name", firstBacklogData.getPreAgentPerformerName());
                } else {
                    data.put("activity__prePerformer_Id", firstBacklogData.getPrePerformerId());
                    data.put("activity__prePerformer_Name", firstBacklogData.getPrePerformerName());
                }
            }
            data.put("businessUnit", (hasBusinessUnit = Objects.nonNull(taskWithBacklogData.getBusinessUnit())) ? taskWithBacklogData.getBusinessUnit() : executeContext.getBusinessUnit());
            data.put("activity__planEndTime", firstBacklogData.getPlanEndTime());
            data.put("activity__readCount", firstBacklogData.getReadCount());
            ActivityUtils.addActivityData(data, firstBacklogData);
            if (IS_SOLVE_CATEGORY) {
                SolveUtil.addTraceData(executeContext, detailFieldFinal, taskWithBacklogData, firstBacklogData, data);
            } else if (IS_APPROVAL_CATEGORY && IS_IDENTITY_CHARGE) {
                ApprovalUtil.addTaskData(executeContext, taskWithBacklogData, firstBacklogData, data);
            } else if (IS_DERIVE_PATTERN && taskWithBacklogData.getBpmData() != null && taskWithBacklogData.getBpmData().containsKey("__DERIVE_TASK_RELATION_UNIKEYS") && taskWithBacklogData.getBpmData().containsKey("__DERIVE_TASK_RELATION")) {
                DeriveUtil.addSubTaskData(taskWithBacklogData, data);
            }
            if (IS_APPROVAL_CATEGORY || !IS_IDENTITY_PERFORMER || null == taskWithBacklogData.getRelationApproval()) continue;
            ApprovalUtil.addTaskData(taskWithBacklogData, firstBacklogData, data);
        }
    }
}

