package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *  处理Activity想过公共方法
 * @author xiachao
 */
public class ActivityUtils {
    public final static String ACTIVITY_START_TIME_STR = "activity__startTime";
    public final static String ACTIVITY_END_TIME_STR = "activity__endTime";

    /**
     * 增加默认的开始时间完成时间
     * @param data 查询的数据
     * @param backlogData 任务的数据
     */
    public static void addActivityData(Map<String, Object> data, BacklogData backlogData){
        data.put(ACTIVITY_START_TIME_STR,backlogData.getStartTime());
        data.put(ACTIVITY_END_TIME_STR,backlogData.getEndTime());
    }

    /**
     * 根据字段编码和描述创造通用的任务的元数据字段
     * @param name 字段编码
     * @param description 字段描述
     * @return 元数据字段
     */
    public static MetadataField createMetadataField(String name, String description){
        MetadataField metadataField = new MetadataField();
        metadataField.setUiBot("Y");
        metadataField.setName(name);
        metadataField.setDataType("string");
        metadataField.setDescription(description);
        return metadataField;
    }

    /**
     *  添加任务的开始日期完成日期的元数据
     * @param metadataFields 元数据
     * @param messageUtils 国际化
     */
    public static void addActivityMetadataField(List<MetadataField> metadataFields,MessageUtils messageUtils){
        metadataFields.add(createMetadataField(ACTIVITY_START_TIME_STR, messageUtils.getMessage("uibot.activity.metadataField.startTime")));
        metadataFields.add(createMetadataField(ACTIVITY_END_TIME_STR, messageUtils.getMessage("uibot.activity.metadataField.completionTime")));
    }

    public static void addActivityMetadataField(List<MetadataField> metadataFields){
        addActivityMetadataField(metadataFields, SpringUtil.getBean(MessageUtils.class));
    }

    /**
     * 设置dispatchData为表单数据
     * @param paras
     * @param parameter
     * @return
     */
    public static List<Map<String,Object>> addDispatchData(Map<String, Object> paras,Map<String, Object> parameter){

        if(MapUtils.isEmpty(paras) || MapUtils.isEmpty(parameter)){
            return null;
        }
        for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
            if (!stringObjectEntry.getKey().startsWith("uibot")){
                Object value = stringObjectEntry.getValue();
                if(value instanceof Map){
                    Map<String, Object> row = (Map<String, Object>) value;
                    if(!row.isEmpty()){
                        Map<String,Object> dispatchData = Maps.newHashMapWithExpectedSize(2);
                        ArrayList<Map<String,Object>> arrayList = Lists.newArrayList(row);
                        dispatchData.put(stringObjectEntry.getKey(),arrayList);
                        paras.put("dispatchData",dispatchData);
                        return arrayList;
                    }
                }else if(value instanceof List){
                    List<Map<String,Object>> dispatchDataList = (List<Map<String, Object>>) value;
                    if(!dispatchDataList.isEmpty()){
                        Map<String,Object> dispatchData = Maps.newHashMapWithExpectedSize(2);
                        dispatchData.put(stringObjectEntry.getKey(),dispatchDataList);
                        paras.put("dispatchData",dispatchData);
                        return dispatchDataList;
                    }
                }
            }
        }
        return null;
    }

}
