package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.*;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Service("flatService")
public class FlatDataSourceService implements DataSourceProcessService {

    /**
     * 对元数据处理
     *
     * @param dataSourceBase      查询的结果的数据
     * @param executeContext      执行上下文
     * @param dataSourceProcessor 处理器
     * @param queryResult         查询结果
     */
    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (dataSourceProcessor.getParas() == null
                || queryResult == null
                || queryResult.getApiMetadataCollection() == null
                || queryResult.getApiMetadataCollection().getMasterApiMetadata() == null
                || queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().size() == 0) {
            return;
        }
        Map<String, String> paras = (Map<String, String>) dataSourceProcessor.getParas();
        if (!paras.containsKey("flatData")) {
            return;
        }
        String detailName = paras.get("flatData");

        MetadataField root = queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().get(0);
        Optional<MetadataField> optionalMetadataField = root.getSubFields().stream()
                .filter(metadataField ->detailName.equals(metadataField.getName()) && metadataField.getSubFields() != null && metadataField.getSubFields().size() > 0 )
                .findFirst();
        if (optionalMetadataField.isPresent()){
            List<MetadataField> detailSubFields = new ArrayList<>();
            MetadataField detailField = optionalMetadataField.get();
            detailSubFields.addAll(detailField.getSubFields());
            root.getSubFields().forEach(parentMetadataField -> {
                if (!detailName.equals(parentMetadataField.getName())
                        && detailSubFields.stream().filter(metadataField1 -> metadataField1.getName().equals(parentMetadataField.getName())).count() == 0) {
                    detailSubFields.add(parentMetadataField);
                }
            });
            root.setSubFields(detailSubFields);
            List<String> dataKeys = detailSubFields.stream()
                    .filter(metadataFieldDTO -> BooleanUtils.isTrue(metadataFieldDTO.getBusinessKey()))
                    .map(MetadataField::getName)
                    .collect(Collectors.toList());
            if (dataKeys !=null && dataKeys.size()>0) {
                dataSourceBase.setDataKeys(dataKeys);
                queryResult.setDataKeys(dataKeys);
            }
        }

    }

    /**
     * 对数据处理
     *
     * @param dataSourceBase
     * @param executeContext
     * @param dataSourceProcessor 处理器
     * @param queryResult
     */
    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (dataSourceProcessor.getParas() == null || queryResult.getData() == null || queryResult.getData().size() == 0) {
            return;
        }
        Map<String, String> paras = (Map<String, String>) dataSourceProcessor.getParas();
        if (!paras.containsKey("flatData")) {
            return;
        }
        String detailName = paras.get("flatData");
        List<Map<String, Object>> newData = new ArrayList<>();
        queryResult.getData().forEach(item -> {
            item.entrySet().forEach(rootRowItem -> {
                if (detailName.equals(rootRowItem.getKey()) && rootRowItem.getValue() instanceof List) {
                    List<Map<String, Object>> detailItemList = (List<Map<String, Object>>) rootRowItem.getValue();
                    newData.addAll(detailItemList);
                    detailItemList.forEach(detailItem -> {
                        item.entrySet().forEach(parentRow -> {
                            if (!detailName.equals(parentRow.getKey()) && !detailItem.containsKey(parentRow.getKey())) {
                                detailItem.put(parentRow.getKey(), parentRow.getValue());
                            }
                        });
                    });
                    return;
                }
            });
        });
        //替换原有数据源
        if (newData.size()>0){
            queryResult.resetData(newData);
        }
    }
}
