package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.thememap.CommonThemeMapService;
import lombok.Data;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.support.DefaultConversionService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public abstract class DataSourceBase {

    private DefaultConversionService defaultConversionService =  new DefaultConversionService();
    /**
     * 数据源的名称
     */
    private String name;

    /**
     * 数据的key字段
     */
    private List<String> dataKeys;

    /**
     * 数据源类型
     */
    private String type;

    private String actionId;
    /**
     * 数据的实际获取的action
     */
    private QueryAction action;

    /**
     * 查询的笔数
     */
    private Integer limit;

    /**
     * 是否为单笔数据
     */
    private Boolean single;

    /**
     * 提供的数据源描述，如果数据源非esp的，或者通过actionid获取不到元数据的，可以通过这个集合来定义数据源的结果
     */
    private List<MetadataField> metadataFields;

    List<DataSourceProcessor>  dataSourceProcessors;

    /**
     * 扩展信息
     */
    private HashMap<String,  Object> extendedData;

    /**
     * 查询数据和元数据
     * @param executeContext 执行上下文
     * @param parameter 执行参数
     * @return
     */
    public QueryResult queryWithMetaData(ExecuteContext executeContext,  Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo){

        QueryResult queryResult = query(executeContext,parameter,pageInfo,sortInfo,searchInfo);
        this.queryMetaData(executeContext, parameter,queryResult);
        return queryResult;
    }

    /**
     * 查询数据
     * @param executeContext 执行上下文
     * @param parameter 参数
     * @param pageInfo 分页信息
     * @return
     */
    public QueryResult query(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo) {
        //处理传递过来的参数
        processParameter(parameter,executeContext);

        QueryResult queryResult = queryCore(executeContext, parameter,pageInfo,sortInfo,searchInfo);

        //是否为非集合数据
        if (this.single != null && this.single) {
            queryResult.setSingle(true);
            //如果是非集合，
            this.limit = 1;
        }
        //如果需要设置固定行，则处理查询结果
        if (limit != null && limit > 0) {
            queryResult.setLimit(limit);
        }

        //初始化数据索引
        queryResult.setDataKeys(this.dataKeys);
        queryResult.initializeDataKey();
        //处理器执行
        this.invokeDataProcessor(executeContext, parameter, queryResult);

        if(limit != null && limit>0 && queryResult.getLimit()!=null && queryResult.size()!=queryResult.getLimit()){
            // 为什么要再执行一次，因为如果有flatService的时候，可能会平铺出多条数据出来
            queryResult.setLimit(limit);
            queryResult.setDataKeys(this.dataKeys);
            queryResult.initializeDataKey();
        }
        return queryResult;
    }


    /**
     * 查询总行数
     * @param executeContext 执行上下文
     * @param parameter 参数
     * @return
     */
    @Deprecated
    public int size(ExecuteContext executeContext, Map<String, Object> parameter,String sizeType){
       return this.size(DataQuery.builder()
               .executeContext(executeContext)
               .parameter(parameter)
               .rowSizeType(sizeType)
               .build());
    }

    /**
     * 查询总行数
     *
     * @param dataQuery 查询条件
     * @return 行数
     */
    public int size(DataQuery dataQuery) {
        processParameter(dataQuery.getParameter(), dataQuery.getExecuteContext());
        QueryResult queryResult = query(dataQuery.getExecuteContext(), dataQuery.getParameter(),
                dataQuery.getPageInfo(), dataQuery.getSortInfo(), dataQuery.getSearchInfo());
        if (limit != null) {
            queryResult.setLimit(limit);
        }
        if (queryResult.isHasNext()) {
            // 若有下一页，取total_results；
            return queryResult.getTotalResults();
        } else if ("byDataKey".equals(dataQuery.getRowSizeType())) {
            // 按照业务主键计算
            return queryResult.keySize();
        } else {
            // 取data.size
            return queryResult.size();
        }
    }

    /**
     * 数据个数、异常数据个数
     * @Author：SYQ
     * @Date：2022/5/23 15:38
     */
    public Map<String,Integer> getDataSize(ExecuteContext executeContext, Map<String, Object> parameter,String sizeType){
        Map<String,Integer> resultMap = new HashMap<>();
        //处理传递过来的参数
        processParameter(parameter,executeContext);

        QueryResult queryResult = query(executeContext,parameter,null,null,null);
        //如果需要设置固定行，则处理查询结果
        if (limit != null) {
            queryResult.setLimit(limit);
        }
        //暂时取第一个结果集来得到大小
        if("byDataKey".equals(sizeType)){
            resultMap.put("size",queryResult.keySize());
            resultMap.put("abnormalSize",queryResult.getAbnormalDataKeyIndexSize());
        }else{
            resultMap.put("size",queryResult.size());
            resultMap.put("abnormalSize",queryResult.getAbnormalDataSize());
        }
        return resultMap;
    }




    protected void processParameter(Map<String, Object> parameter,ExecuteContext executeContext) {
        if (null == this.getAction()) {
            return;
        }

        if (this.getAction().getParas() == null) {
            this.getAction().setParas(new HashMap<>());
        }
        QueryResult queryResult = new QueryResult();
        queryResult.setData(new ArrayList<>());
        //获取元数据
        ApiMetadataCollection apiMetadataCollection = queryMetaDataCore(executeContext, parameter, queryResult);
        List<MetadataField> requestFields = new ArrayList<>();
        if (apiMetadataCollection != null
                && apiMetadataCollection.getMasterApiMetadata() != null) {
            requestFields = apiMetadataCollection.getMasterApiMetadata().getRequestFields();
        }

        //如果前端有传参数，则做替换
        if (parameter != null) {
            if (CollectionUtils.isEmpty(this.getAction().getActionParams())) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    this.getAction().getParas().put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else {
                Map<String, Object> realParas = this.getAction().getParas();
                for (ActionParameterMapping actionParam : this.getAction().getActionParams()) {
                    if (ActionConstants.ActionType.TM_VARIABLE.equals(actionParam.getType())) {
                        // action.getValue为非空，则尝试获取KM配置；否则action.value值保持原样
                        if (StringUtils.isNotBlank(actionParam.getValue())) {
                            String tenantId = null != executeContext.getAuthoredUser() ? executeContext.getAuthoredUser().getTenantId() : executeContext.getTenantId();
                            Object value = SpringUtil.getBean(CommonThemeMapService.class).queryVariable(tenantId, executeContext.getLocale(), actionParam.getValue());
                            actionParam.setValue(null != value ? String.valueOf(value) : null);
                        }
                        actionParam.setType(ActionConstants.ActionType.CONSTANT);
                    }

                    if ("ACTIVE_ROW".equals(actionParam.getType())) {
                        Object paramValue = parameter.get(actionParam.getValue());
                        /*if(paramValue ==  null){
                            continue;
                        }*/
                        if (actionParam.getTypeConverter() != null) {
                            if ("stringToBooleanConverter".equals(actionParam.getTypeConverter())) {
                                paramValue = defaultConversionService.convert(paramValue.toString(), Boolean.TYPE);
                            } else if ("stringToNumberConverter".equals(actionParam.getTypeConverter())) {
                                paramValue = defaultConversionService.convert(paramValue.toString(), Integer.TYPE);
                            }
                        }
                        //服务端 过滤
                        String conName = actionParam.getName();
                        if (conName.contains(".")) {
                            //指定过滤条件加在哪个参数中
                            String[] conNames = conName.split("\\.");
                            Object p = realParas.get(conNames[0]);
                            if (p != null) {
                                if (p instanceof JSONObject) {
                                    JSONObject pJson = (JSONObject) p;
                                    pJson.put(conNames[1], paramValue);
                                } else if (p instanceof Map) {
                                    Map pJson = (Map) p;
                                    pJson.put(conNames[1], paramValue);
                                } else if (p instanceof JSONArray) {
                                    JSONArray pJsonArray = (JSONArray) p;
                                    for (Object oJson : pJsonArray.toArray()) {
                                        if (oJson instanceof JSONObject) {
                                            JSONObject pJson = (JSONObject) oJson;
                                            pJson.put(conNames[1], paramValue);
                                        }
                                    }
                                } else if (p instanceof List) {
                                    List pJsonArray = (List) p;
                                    if(pJsonArray.size() == 0){
                                        Map paraData = new HashMap();
                                        if(paramValue != null) {
                                            paraData.put(conNames[1], paramValue);
                                            pJsonArray.add(paraData);
                                        }
                                    }else {
                                        for (Object o : pJsonArray) {
                                            if (o instanceof Map) {
                                                Map pJson = (Map) o;
                                                if (paramValue != null) {
                                                    pJson.put(conNames[1], paramValue);
                                                }
                                            }
                                        }
                                    }
                                }
                            } else {
                                Map paraData = new HashMap();
                                if(paramValue != null) {
                                    paraData.put(conNames[1], paramValue);
                                }

                                //根据元数据来判断入参是对象还是数组
                                if (!requestIsArray(requestFields, conNames[0])) {
                                    realParas.put(conNames[0], paraData);
                                } else {
                                    List<Object> o = new ArrayList<>();
                                    if(MapUtils.isNotEmpty(paraData)) {
                                        o.add(paraData);
                                    }
                                    realParas.put(conNames[0], o);
                                }
                            }

                        } else {
                            //直接加到参数中
                            realParas.put(actionParam.getName(), paramValue);
                        }
                    } else if ("ACTIVE_ROW_CONSTANT".equals(actionParam.getType()) || "CONSTANT".equals(actionParam.getType())) {
                        Object paramValue = actionParam.getValue();
                       /* if(paramValue ==  null){
                            continue;
                        }*/
                        if (actionParam.getTypeConverter() != null) {
                            if ("stringToBooleanConverter".equals(actionParam.getTypeConverter())) {
                                paramValue = defaultConversionService.convert(paramValue.toString(), Boolean.TYPE);
                            } else if ("stringToNumberConverter".equals(actionParam.getTypeConverter())) {
                                paramValue = defaultConversionService.convert(paramValue.toString(), Integer.TYPE);
                            }
                        }
                        //服务端 过滤
                        String conName = actionParam.getName();
                        if (conName.contains(".")) {
                            //指定过滤条件加在哪个参数中
                            String[] conNames = conName.split("\\.");
                            Object p = realParas.get(conNames[0]);
                            if (p != null) {
                                if (p instanceof JSONObject) {
                                    JSONObject pJson = (JSONObject) p;
                                    pJson.put(conNames[1], paramValue);
                                } else if (p instanceof Map) {
                                    Map pJson = (Map) p;
                                    pJson.put(conNames[1], paramValue);
                                } else if (p instanceof JSONArray) {
                                    JSONArray pJsonArray = (JSONArray) p;
                                    for (Object oJson : pJsonArray.toArray()) {
                                        if (oJson instanceof JSONObject) {
                                            JSONObject pJson = (JSONObject) oJson;
                                            pJson.put(conNames[1], paramValue);
                                        }
                                    }
                                } else if (p instanceof List) {
                                    List pJsonArray = (List) p;
                                    for (Object o : pJsonArray) {
                                        if (o instanceof Map) {
                                            Map pJson = (Map) o;
                                            pJson.put(conNames[1], paramValue);
                                        }
                                    }
                                }
                            } else {
                                Map paraData = new HashMap();
                                paraData.put(conNames[1], paramValue);
                                //根据元数据来判断入参是对象还是数组
                                if (!requestIsArray(requestFields, conNames[0])) {
                                    realParas.put(conNames[0], paraData);
                                } else {
                                    List<Object> o = new ArrayList<>();
                                    o.add(paraData);
                                    realParas.put(conNames[0], o);
                                }
                            }

                        } else {
                            //直接加到参数中
                            realParas.put(actionParam.getName(), paramValue);
                        }
                    }

                }
            }
        } else {
            //根据元数据来判断入参是对象还是数组
            if (MapUtils.isEmpty(this.getAction().getParas())) {
                return;
            }
            if (CollectionUtils.isEmpty(this.getAction().getActionParams()) || this.getAction().getActionParams().size() == 0) {
                return ;
            }
            Map<String, Object> realParas = this.getAction().getParas();
            String conNames = this.getAction().getActionParams().get(0).getName();
            if (conNames.contains(".")) {
                conNames = conNames.split("\\.")[0];
            }
            if (!requestIsArray(requestFields, conNames)) {
                if(!(realParas.get(conNames) instanceof List)){
                    return;
                }
                List paras =   JsonUtils.jsonToListObject(JsonUtils.objectToString(realParas.get(conNames)), Map.class);
                if(paras instanceof List && paras.size() > 0) {
                    Map parasMapOne = JsonUtils.jsonToListObject(JsonUtils.objectToString(realParas.get(conNames)), Map.class).get(0);
                    this.getAction().getParas().put(conNames,parasMapOne);
                }
            }
        }
    }


    /**
     * 针对现在入参可能是对象，可能是数组的情况下，利用元数据上的requestFields来判断入参是什么
     * @param requestFields
     * @param conNames
     * @return
     */
    private boolean requestIsArray(List<MetadataField> requestFields,String conNames) {
        if (CollectionUtils.isNotEmpty(requestFields)) {
            for (MetadataField metadataField : requestFields) {
                if (conNames.equals(metadataField.getName())
                        && "object".equals(metadataField.getDataType())) {
                    if(BooleanUtils.isTrue(metadataField.getArray())){
                        return  true;
                    }else{
                        return  false;
                    }
                }
            }
        }
        return true;
    }


    /**
     * 调用所有的元数据处理器
     * @param executeContext
     * @param parameter
     * @param queryResult
     */
    protected void invokeMetaDataProcessor(ExecuteContext executeContext,  Map<String, Object> parameter, QueryResult queryResult) {
        if (CollectionUtils.isNotEmpty(this.dataSourceProcessors)){
            for (DataSourceProcessor dataSourceProcessor : this.dataSourceProcessors) {
                if(StringUtils.isBlank(dataSourceProcessor.getServiceName())){
                    continue;
                }
                if("service".equals(dataSourceProcessor.getType())){
                    DataSourceProcessService processService = (DataSourceProcessService) SpringUtil.tryGetBean(dataSourceProcessor.getServiceName());
                    if (processService!=null) {
                        processService.handelMetadata(this,executeContext,dataSourceProcessor, queryResult);
                    }
                }
            }
        }
    }

    /**
     * 调用所有的数据处理器
     * @param executeContext
     * @param parameter
     * @param queryResult
     */
    protected void invokeDataProcessor(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        if (CollectionUtils.isNotEmpty(this.dataSourceProcessors)){
            for (DataSourceProcessor dataSourceProcessor : this.dataSourceProcessors) {
                if(StringUtils.isBlank(dataSourceProcessor.getServiceName()) || UiBotConstants.DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED.equals(dataSourceProcessor.getActivePoint())){
                    continue;
                }
                if("service".equals(dataSourceProcessor.getType())){
                    DataSourceProcessService processService = (DataSourceProcessService) SpringUtil.tryGetBean(dataSourceProcessor.getServiceName());
                    if (processService!=null) {
                        processService.handelData(this,executeContext,dataSourceProcessor,queryResult);
                    }
                }
            }
        }
    }


    /**
     * 查询数据
     * @param executeContext 执行上下文
     * @param parameter 参数
     * @return
     */
    protected abstract QueryResult queryCore(ExecuteContext executeContext , Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo);

    /**
     * 附加数据的元数据
     * @param executeContext 执行上下文
     * @param parameter 参数
     * @return
     */
    protected ApiMetadataCollection queryMetaData(ExecuteContext executeContext , Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = queryMetaDataCore(executeContext,  parameter, queryResult);
        if (apiMetadataCollection == null) {
            return null;
        }
        if (queryResult != null) {
            queryResult.withMetaData(apiMetadataCollection);
            this.invokeMetaDataProcessor(executeContext,  parameter, queryResult);
            if (this.metadataFields != null) {
                if (queryResult.getApiMetadataCollection().getMasterApiMetadata() == null) {
                    queryResult.getApiMetadataCollection().setMasterApiMetadata(new ApiMetadata());
                }
                queryResult.getApiMetadataCollection().getMasterApiMetadata().addVirtuallyResponseFields(this.metadataFields);
            }
            if (this.single != null && this.single) {
                this.limit = 1;
                queryResult.setLimit(1);
                if (CollectionUtils.isNotEmpty(queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields())) {
                    queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().get(0).setArray(false);
                }
            }
            if(this.single == null){
                if(apiMetadataCollection.getMasterApiMetadata() != null
                        && CollectionUtils.isNotEmpty(apiMetadataCollection.getMasterApiMetadata().getResponseFields())
                        && apiMetadataCollection.getMasterApiMetadata().getResponseFields().size() > 0) {
                    MetadataField metadataField = apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0);
                    this.single = !BooleanUtils.isTrue(metadataField.getArray());
                    queryResult.setSingle(this.single);
                }
            }
        }
        return apiMetadataCollection;
    }

    /**
     * 附加数据的元数据
     * @param executeContext 执行上下文
     * @param parameter 参数
     * @return
     */
    protected  abstract ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext ,Map<String, Object> parameter, QueryResult queryResult);



    public DataSourceBase copyWithoutProcessor(){
        return this.copyWithoutProcessorCore();
    }

    protected abstract DataSourceBase copyWithoutProcessorCore();

}
