package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.datasource.domain.*;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

@Data
public class RawDataSource extends DataSourceBase {
    /**
     * 直接获取数据
     */
    private HashMap<String,Object> rawData;


    public  RawDataSource(){
        super();
        this.setType(UiBotConstants.ACTION_CATEGORY_RAW_DATA);
    }



    /**
     * 查询数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @return
     */
    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo) {
        if (this.rawData == null) {
            return QueryResult.empty(this.getName());
        } else {
            //todo:数据源只能处理api返回的第一个数据，是否合理需要后续来看怎么处理。
            AtomicReference<QueryResult> queryResult = new AtomicReference<>();
            rawData.forEach((k, v) -> {
                //返回的数据源可能是集合也可能非集合
                if (v instanceof Collection) {
                    queryResult.set(QueryResult.withData(this.getName(), (List<Map<String, Object>>) v));
                } else {
                    if(v instanceof Map) {
                        queryResult.set(QueryResult.withSingleData(this.getName(), (Map<String, Object>) v));
                    }else{
                        Map vv_t =  new HashMap();
                        vv_t.put(k,v);
                        queryResult.set(QueryResult.withSingleData(this.getName(), (Map<String, Object>) vv_t));
                    }
                }
                return;
            });
            return queryResult.get();
        }
    }

    /**
     * 附加数据的元数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @param queryResult    查询结果
     * @return
     */
    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext,  Map<String, Object> parameter, QueryResult queryResult) {
        //查询元数据
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        String actionId = this.getActionId();
        ApiMetadata apiMetadata = null;
        if(StringUtils.hasText(actionId)){
            apiMetadata = SpringUtil.getBean(CommonMetadataService.class).getMetadata(executeContext.getLocale(), this.getActionId());
        }else {
            List<MetadataField> metadataFields = this.getMetadataFields();
            // actionId为空的情况，虚拟字段不为空的情况
            if(CollectionUtils.isNotEmpty(metadataFields)){
                MetadataField metadataField = metadataFields.get(0);
                apiMetadata = new ApiMetadata();
                apiMetadata.setActionId(metadataField.getName());
            }
        }


//        if (masterMetadataDataDTO == null){
//            apiMetadataCollection = ApiMetadataCollection.empty();
//            apiMetadataCollection.getMasterApiMetadata().setActionId(this.getActionId());
//            return apiMetadataCollection ;
//        }
//        ApiMetadata apiMetadata = MetadataDataDTO2ApiMetadata.createApiMetadata(masterMetadataDataDTO);
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }


    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        RawDataSource rawDataSource = new RawDataSource();
        rawDataSource.setName(this.getName());
        rawDataSource.setAction(this.getAction());
        rawDataSource.setType(this.getType());
        rawDataSource.setDataKeys(this.getDataKeys());
        rawDataSource.setActionId(this.getActionId());
        rawDataSource.setRawData(this.rawData);
        return rawDataSource;
    }
}
