/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.datasource.res.DesensitizationFieldsRes;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.util.SearchInfoUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.StringUtils;

public class EspDataSource
extends DataSourceBase {
    public EspDataSource() {
        this.setType("ESP");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        Object returnSummaryFields;
        if (this.getAction() == null) {
            return QueryResult.empty((String)this.getName());
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("parameter", parameter);
        paramMap.put("pageInfo", pageInfo);
        paramMap.put("sortInfo", sortInfo);
        paramMap.put("searchInfo", searchInfo);
        Map paras = this.getAction().getParas();
        if (pageInfo != null) {
            List detailPageInfo;
            if (!pageInfo.isNextAllData()) {
                paras.put("use_has_next", true);
                if (pageInfo.getPageSize() != null) {
                    paras.put("page_size", pageInfo.getPageSize());
                }
                if (pageInfo.getPageNo() != null) {
                    paras.put("page_no", pageInfo.getPageNo());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(detailPageInfo = pageInfo.getDetailPageInfo()))) {
                List mapList = detailPageInfo.stream().map(o -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("page_no", o.getPageNo());
                    map.put("page_size", o.getPageSize());
                    map.put("use_has_next", o.getUseHasNext());
                    map.put("detail_name", o.getDetailName());
                    map.put("detail_path", o.getDetailPath());
                    return map;
                }).collect(Collectors.toList());
                paras.put("detail_page_info", mapList);
            }
        }
        if (CollectionUtils.isNotEmpty(sortInfo)) {
            ArrayList newSortInfo = new ArrayList();
            for (Map item : sortInfo) {
                if (!StringUtils.hasText((String)item.getOrDefault("schema", "").toString())) continue;
                if (item.get("orderType") != null && item.get("orderType").toString().contains("desc")) {
                    item.put("orderType", "desc");
                } else {
                    item.put("orderType", "asc");
                }
                HashMap sortItem = new HashMap();
                sortItem.put("sort_field", item.get("schema"));
                sortItem.put("sort_type", item.get("orderType"));
                sortItem.put("sort_seq", item.get("order"));
                sortItem.put("table_path", item.get("table_path"));
                if (StrUtil.isNotBlank((CharSequence)((String)item.get("sortFieldPath")))) {
                    sortItem.put("sort_field_path", item.get("sortFieldPath"));
                }
                newSortInfo.add(sortItem);
            }
            paras.put("sort_info", newSortInfo);
        }
        if (CollectionUtils.isNotEmpty(searchInfo)) {
            paras.put("search_value", "");
            paras.put("search_info", SearchInfoUtil.mergeSearchInfo((List)((List)paras.get("search_info")), searchInfo));
        }
        if (!StringUtils.isEmpty((Object)executeContext.getTmActivityId())) {
            paras.put("activityId", executeContext.getTmActivityId());
        }
        if (this.getExtendedData() != null) {
            if (this.getAction().getExtendedFields() == null) {
                this.getAction().setExtendedFields(this.getExtendedData());
            } else {
                this.getAction().getExtendedFields().putAll(this.getExtendedData());
            }
        }
        if (this.getAction().getQueryData() != null && !this.getAction().getQueryData().booleanValue()) {
            return QueryResult.empty((String)this.getName());
        }
        HashMap data = ((CommonESPService)SpringUtil.getBean(CommonESPService.class)).query(executeContext, (Action)this.getAction(), parameter);
        if (data == null || data.size() == 0) {
            QueryResult empty = QueryResult.empty((String)this.getName());
            empty.setReturnRequestData(paramMap);
            return empty;
        }
        QueryResult queryResult = QueryResult.withData((String)this.getName(), (Map)data, (PageInfo)pageInfo);
        Object hasNext = data.get("has_next");
        Object totalResults = data.get("total_results");
        if (hasNext instanceof Boolean) {
            queryResult.setHasNext(((Boolean)hasNext).booleanValue());
        }
        if (totalResults instanceof Number) {
            queryResult.setTotalResults(Integer.valueOf(NumberUtil.toBigDecimal((Number)((Number)totalResults)).intValue()));
        } else if (totalResults instanceof String) {
            queryResult.setTotalResults(Integer.valueOf(NumberUtil.toBigDecimal((String)((String)totalResults)).intValue()));
        }
        Object returnPageInfo = data.get("return_page_info");
        if (returnPageInfo instanceof Collection) {
            queryResult.setReturnPageInfo((Collection)returnPageInfo);
        }
        if ((returnSummaryFields = data.get("return_summary_fields")) instanceof Map) {
            queryResult.setReturnSummaryFields((Map)returnSummaryFields);
        }
        queryResult.setReturnRequestData(paramMap);
        Object o2 = data.get("desensitizationFields");
        if (o2 instanceof List) {
            List list = (List)o2;
            ArrayList desensitizationFields = Lists.newArrayListWithExpectedSize((int)list.size());
            for (Object element : list) {
                if (!(element instanceof Map)) continue;
                Map row = (Map)element;
                DesensitizationFieldsRes res = new DesensitizationFieldsRes();
                res.setConfidentialType(MapUtils.getString((Map)row, (Object)"confidentialType"));
                res.setFieldCode(MapUtils.getString((Map)row, (Object)"fieldCode"));
                desensitizationFields.add(res);
            }
            queryResult.setDesensitizationFields((List)desensitizationFields);
        }
        return queryResult;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        ApiMetadata apiMetadata = ((CommonMetadataService)SpringUtil.getBean(CommonMetadataService.class)).getMetadata(executeContext.getLocale(), this.getAction().getActionId());
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        EspDataSource espDataSource = new EspDataSource();
        espDataSource.setName(this.getName());
        espDataSource.setAction(this.getAction());
        espDataSource.setType(this.getType());
        espDataSource.setDataKeys(this.getDataKeys());
        espDataSource.setActionId(this.getActionId());
        return espDataSource;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EspDataSource)) {
            return false;
        }
        EspDataSource other = (EspDataSource)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EspDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "EspDataSource()";
    }
}

