package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.thememap.CommonThemeMapService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class TmFormulaDataSource extends   DataSourceBase {

    public TmFormulaDataSource( ){
        super();
        this.setType(UiBotConstants.ACTION_CATEGORY_TM);
    }

    /**
     * 查询数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @return
     */
    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo) {
        if (this.getAction() == null){
            return QueryResult.empty(this.getName());
        }
        if ( this.getAction().getParas() ==null){
            return QueryResult.empty(this.getName());
        }

        Map<String, Object> map = this.getAction().getParas();
        String formulaId = map.get("formulaId").toString();

        if (StringUtils.isEmpty( formulaId )){
            return  QueryResult.empty(this.getName());
        }

        HashMap formulaMap = SpringUtil.getBean(CommonThemeMapService.class).executeFormula(formulaId);

        List<Object> list = new ArrayList<>();
        list.add(formulaMap);
        Map<String,List<Object>> espData = new HashMap<>();
        espData.put("response", list);
        QueryResult queryResult = QueryResult.withData( this.getName(),espData);
        return  queryResult;
    }


    /**
     * 附加数据的元数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @param queryResult    查询结果
     * @return
     */
    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext,  Map<String, Object> parameter, QueryResult queryResult) {
        //todo: 根据数据来造metadata
        return null;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        TmFormulaDataSource tmDataSource = new TmFormulaDataSource();
        tmDataSource.setName(this.getName());
        tmDataSource.setAction(this.getAction());
        tmDataSource.setType(this.getType());
        tmDataSource.setDataKeys(this.getDataKeys());
        tmDataSource.setActionId(this.getActionId());
        return tmDataSource;
    }
}
