package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.TaskWithBacklogData;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApprovalUtil {


    public static void addTaskData(ExecuteContext executeContext, TaskWithBacklogData taskWithBacklogData, BacklogData firstBacklogData, Map<String, Object> data) {
        //签核型项目卡
        JSONObject dataItem = new JSONObject();
        dataItem.put("approve", 0);
        if(!CollectionUtils.isEmpty(firstBacklogData.getWorkitemList())){
            Map<String,Object> workitem = firstBacklogData.getWorkitemList().get(0);
            if(workitem.containsKey("state")) {
                dataItem.put("approve", workitem.get("state"));
                //签核型增加子状态
                if(workitem.containsKey("subState")) {
                    dataItem.put("subState", workitem.get("subState"));
                }
            }
        }
        List<Map> processInstances = new ArrayList<>();
        Map processInstance = new HashMap();
        processInstance.put("processSerialNumber", taskWithBacklogData.getProcessSerialNumber());
        List<String> tmActivityIds = new ArrayList<>();
        tmActivityIds.add(executeContext.getTmActivityId());
        processInstance.put("tmActivityIds", tmActivityIds);
        processInstance.put("workitemId", firstBacklogData.getBacklogId());
        processInstances.add(processInstance);
        dataItem.put("processInstances", processInstances);
        data.put("activity__approval__state", dataItem);

    }


    public static void addTaskData(TaskWithBacklogData taskWithBacklogData, BacklogData firstBacklogData, Map<String, Object> data) {
        //签核型项目卡
        JSONObject dataItem = new JSONObject();
        dataItem.put("approve", 0);
        if(!CollectionUtils.isEmpty(firstBacklogData.getWorkitemList())){
            Map<String,Object> workitem = firstBacklogData.getWorkitemList().get(0);
            if(workitem.containsKey("state")) {
                dataItem.put("approve", workitem.get("state"));
                //签核型增加子状态
                if(workitem.containsKey("subState")) {
                    dataItem.put("subState", workitem.get("subState"));
                }
            }
        }
        dataItem.put("processInstances", Arrays.asList(taskWithBacklogData.getRelationApproval()));
        data.put("activity__approval__state", dataItem);
    }

    /**
     * 添加退回意见
     * @param firstBacklogData
     * @param data
     */
    public static Map<String, Object> addReturnComments(BacklogData firstBacklogData, Map<String, Object> data) {
        Map<String, Object> returnComment = new HashMap<>();
        if(CollectionUtils.isEmpty(firstBacklogData.getWorkitemList())){
            return returnComment;
        }

        Map<String,Object> workitem = firstBacklogData.getWorkitemList().get(0);
        if(!workitem.containsKey("returnWorkitem")){
            return returnComment;
        }

        Map<String,Object> returnWorkitem = (Map<String,Object>) workitem.get("returnWorkitem");

        if(!returnWorkitem.containsKey("dataItems") || !returnWorkitem.containsKey("uniKeys") || !returnWorkitem.containsKey("comment")){
            return returnComment;
        }
        List<Map<String,Object>> dataItems = (List<Map<String,Object>>) returnWorkitem.get("dataItems");
        List<String> uniKeys = (List<String>) returnWorkitem.get("uniKeys");

        for(Map<String,Object> dataItem : dataItems){
            // 获取bpm数据项的key串
            String dataItemKeyStr = ApprovalUtil.generateIndexKey(uniKeys,dataItem);
            if(StringUtils.isEmpty(dataItemKeyStr)){
                continue;
            }

            // 获取应用数据的key串
            String dataKeyStr = ApprovalUtil.generateIndexKey(uniKeys,data);
            if(StringUtils.isEmpty(dataKeyStr)){
                continue;
            }
            // 如果匹配上，则在返回数据行中添加该退回意见
            if(dataItemKeyStr.equals(dataKeyStr)){
                returnComment.put("returnComment", returnWorkitem.get("comment"));
            }
        }
        return returnComment;
    }

    /**
     * 判断map集合中是否包含maoKeys的所有key，并且用分号分隔符生成新的indexKey
     *
     * @param mapKeys 条件key集合
     * @param map     元数据
     * @param <T>     类型
     * @return 索引值
     */
    private static <T> String generateIndexKey(List<String> mapKeys, Map<String, T> map) {
        //用于计数，判断返回的数据是否都包含对应的mapKey
        int i = 0;
        for (String tempKey : mapKeys) {
            //如果包含，则计数+1
            if (map.containsKey(tempKey)) i++;
        }
        //如果计数值等于mapKeys长度，说明该返回数据符合条件
        StringBuilder indexKey = new StringBuilder();
        if (i == mapKeys.size()) {
            for (String tempKey : mapKeys) {
                indexKey.append(MapUtils.getString(map, tempKey)).append(";");
            }
        }
        return indexKey.toString();
    }

}
