package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.thememap.CommonThemeMapService;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanItemsDTO;
import com.digiwin.athena.atdm.thememap.dto.TargetDTO;
import com.digiwin.athena.atdm.datasource.domain.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 智能推荐服务
 */
@Slf4j
@Service("planSelectSuggestService")
public class PlanSelectSuggestService implements DataSourceProcessService {

    private static final String PLAN_SELECT_OPTIONS = "KM_PLAN_SELECT_SUGGEST_OPTIONS";

    @Autowired
    private CommonThemeMapService commonThemeMapService;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {

        ApiMetadataCollection apiMetadataCollection = queryResult.getApiMetadataCollection();
        if (apiMetadataCollection == null) {
            return;
        }
        if (queryResult == null || CollectionUtils.isEmpty(queryResult.getData())) {
            return;
        }

        if (apiMetadataCollection != null
                && apiMetadataCollection.getMasterApiMetadata() != null
                && CollectionUtils.isNotEmpty(apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {

            List<MetadataField> metadataFields = apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).getSubFields();

            MetadataField planTypeReasonField = new MetadataField();
            planTypeReasonField.setUiBot("Y");
            planTypeReasonField.setName(PLAN_SELECT_OPTIONS);
            planTypeReasonField.setDataType("object");
            Map<String, Integer> planPrecision = new HashMap<>();
            planPrecision.put("length", 120);
            planTypeReasonField.setPrecision(planPrecision);
            planTypeReasonField.setDescription(MessageUtils.getMessageByCurrentLanguage("{\"zh_TW\":\"方案選擇理由\",\"en_US\":\"Reasons for plan selection\",\"zh_CN\":\"方案选择理由\"}"));
            metadataFields.add(planTypeReasonField);
        }
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {

        if (queryResult == null || CollectionUtils.isEmpty(queryResult.getData())) {
            return;
        }
        try {
            if (dataSourceProcessor.getParas() == null || !(dataSourceProcessor.getParas() instanceof Map)) {
                return;
            }
            Map<String, Object> map = (Map<String, Object>) dataSourceProcessor.getParas();

            if (!map.containsKey("decisionCode") || map.get("decisionCode") == null) {
                log.warn(String.format("配置任务%s的数据处理器[planSelectSuggestService]缺少decisionCode字段或者值", executeContext.getTmActivityId()));
                return;
            }
            if (!map.containsKey("planField")) {
                log.warn(String.format("配置任务%s的数据处理器[planSelectSuggestService]缺少planField字段或者值", executeContext.getTmActivityId()));
                return;
            }
            String decisionCode = map.get("decisionCode").toString();
            String planField = map.get("planField").toString();
            List<Map<String,Object>> datas = queryResult.getData();
            if (map.containsKey("keyFields") && map.get("keyFields") != null && map.get("keyFields") instanceof List) {
               List fields =(List) map.get("keyFields");
                List<Map<String,Object>> newDatas=new ArrayList<>();
                for (Map<String, Object> data : datas) {
                    Map<String,Object> newData = new HashMap<>();
                    newData.put("__DATA_KEY",data.get("__DATA_KEY"));
                    for (Object field : fields) {
                        if (data.containsKey(field)){
                            newData.put(field.toString(),data.get(field));
                        }
                    }
                    newDatas.add(newData);
                }
                datas = newDatas;
            }

            List<SuggestPlanItemsDTO> suggestPlanItemsDTOS = commonThemeMapService.getSuggestPlan(executeContext.getLocale(), decisionCode,datas);
            if (suggestPlanItemsDTOS == null) {
                return;
            }
            for (SuggestPlanItemsDTO suggestPlanItemsDTO : suggestPlanItemsDTOS) {
                if (!StringUtils.isEmpty(suggestPlanItemsDTO.getKey())
                        && CollectionUtils.isNotEmpty(suggestPlanItemsDTO.getTargets())) {
                    Map<String, Object> data = queryResult.findByKey(suggestPlanItemsDTO.getKey());
                    if (data == null) {
                        continue;
                    }
                    List<Map<String, Object>> options = new ArrayList<>();
                    for (TargetDTO target : suggestPlanItemsDTO.getTargets()) {
                        Map<String, Object> option = new HashMap<>();
                        option.put("title", target.getPlanName());
                        option.put("value", target.getPlanId());
                        options.add(option);
                    }
                    data.put(PLAN_SELECT_OPTIONS, options);
                    if (data.containsKey(planField) && options.size() > 0) {
                        data.put(planField, options.get(0).get("value"));
                    }
                }
            }

        } catch (Exception e) {
            //吃掉异常，不影响整体流程
            log.error(e.getMessage(), e);
            return;
        }
    }
}
