/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.lcdp.CommonLcdpService;
import com.digiwin.athena.atdm.util.SearchInfoUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

public class LcdpDataSource
extends DataSourceBase {
    public LcdpDataSource() {
        this.setType("LCDP");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        HashMap data;
        if (this.getAction() == null) {
            return QueryResult.empty((String)this.getName());
        }
        Map paras = this.getAction().getParas();
        if (pageInfo != null && !pageInfo.isNextAllData()) {
            paras.put("use_has_next", true);
            if (pageInfo.getPageSize() != null) {
                paras.put("page_size", pageInfo.getPageSize());
            }
            if (pageInfo.getPageNo() != null) {
                paras.put("page_no", pageInfo.getPageNo());
            }
        }
        if (CollectionUtils.isNotEmpty(sortInfo)) {
            ArrayList newSortInfo = new ArrayList();
            for (Map item : sortInfo) {
                if (!StringUtils.hasText((String)item.getOrDefault("schema", "").toString())) continue;
                if (item.get("orderType") != null && item.get("orderType").toString().contains("desc")) {
                    item.put("orderType", "desc");
                } else {
                    item.put("orderType", "asc");
                }
                HashMap sortItem = new HashMap();
                sortItem.put("sort_field", item.get("schema"));
                sortItem.put("sort_type", item.get("orderType"));
                sortItem.put("sort_seq", item.get("order"));
                newSortInfo.add(sortItem);
            }
            paras.put("sort_info", newSortInfo);
        }
        if (CollectionUtils.isNotEmpty(searchInfo)) {
            paras.put("search_value", "");
            paras.put("search_info", SearchInfoUtil.mergeSearchInfo((List)((List)paras.get("search_info")), searchInfo));
        }
        if (parameter != null && this.getAction().getParas() == null && this.getAction().getActionParams() == null) {
            this.getAction().setParas(new HashMap());
            for (Map.Entry entry : parameter.entrySet()) {
                this.getAction().getParas().put(entry.getKey(), entry.getValue());
            }
        }
        if ((data = ((CommonLcdpService)SpringUtil.getBean(CommonLcdpService.class)).query(executeContext, (Action)this.getAction())) == null || data.size() == 0) {
            return QueryResult.empty((String)this.getName());
        }
        QueryResult queryResult = QueryResult.withData((String)this.getName(), (Map)data, (PageInfo)pageInfo);
        Set keys = data.keySet();
        if (keys.size() > 0) {
            if (keys.contains("has_next") && data.get("has_next") != null) {
                queryResult.setHasNext(((Boolean)data.get("has_next")).booleanValue());
            }
            if (keys.contains("total_results") && data.get("total_results") != null) {
                queryResult.setTotalResults((Integer)data.get("total_results"));
            }
        }
        return queryResult;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        apiMetadataCollection.setMasterApiMetadata(new ApiMetadata());
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        LcdpDataSource lcdpDataSource = new LcdpDataSource();
        lcdpDataSource.setName(this.getName());
        lcdpDataSource.setAction(this.getAction());
        lcdpDataSource.setType(this.getType());
        lcdpDataSource.setDataKeys(this.getDataKeys());
        lcdpDataSource.setActionId(this.getActionId());
        return lcdpDataSource;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LcdpDataSource)) {
            return false;
        }
        LcdpDataSource other = (LcdpDataSource)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LcdpDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "LcdpDataSource()";
    }
}

